// nff export filter.

#include "world.H"
#include "nff/exporter.H"
#include "nff/renderer.H"

namespace nff {
  exporter::exporter(char* progname)
  {
    exporter::progname = progname;
  }

  void exporter::init(class xrml::file* file_handle)
  {
    // save private copy of the file handle
    fh = file_handle;
  }

  void exporter::save(class xrml::world* wrl)
  {
    // temporarily replace the current renderer by a
    // NFF conversion renderer
    xrml::renderer* old_renderer = wrl->set_renderer(new nff::renderer(fh, progname));

    // render the current frame
    wrl->render();

    // re-install the original renderer and delete the 
    // NFF conversion renderer
    delete wrl->set_renderer(old_renderer);
  }
}
