/* nff/renderer.H: NFF export renderer */

#ifndef _NFF_RENDERER_H_
#define _NFF_RENDERER_H_

// include xrml::renderer base class declaration
// (This header gets installed in <path>/include/nff and
// the base renderer.H header file in <path>/include).
#include "../renderer.H"

namespace nff {
  using namespace xrml;

  class renderer: public xrml::renderer {
  private:
    char* progname;
    class file* fh;

  public:
    void begin_frame(class world*);
    void viewpoint(class Viewpoint*);
    void begin_PointLight(class PointLight*);
    void begin_SpotLight(class SpotLight*);
    void begin_Material(class Material *);
    void begin_face(int, int);
    void vertex_coord(int, const SFVec3f&);
    void end_face(int, int);

    renderer(class file* file_handle, char* progname =0);
  };
} // end nff namespace

#endif /*_NFF_RENDERER_H_*/
