// importer.H: ply importer - Ingo Wald, February 18, 2001

#ifndef _PLY_IMPORTER_H_
#define _PLY_IMPORTER_H_

#include "../importer.H"

namespace ply {
  using namespace xrml;

struct Vertex {
  float pos[3];            
  float nor[3];
  unsigned char col[3];

  bool posValid;
  bool norValid;
  bool colValid;

  void Reset() 
  { colValid = posValid = norValid = false; };
};

struct Face {
  int id;
  unsigned char nverts;   
  int *verts;             

  unsigned char col[3];
  bool colValid;

  void Reset() 
  { colValid = false; };
};

class importer: public xrml::importer {
protected:
  MFInt32 *coordIndex;

  bool hasVtxColor;
  bool hasFaceColor;

  MFVec3f *vtxPos;
  MFVec3f *vtxNor;
  MFColor *vtxCol;
  
  MFColor *faceCol;

  void Finalize();
  void PrepareFaces(Face &fType,int nfaces);
  void PrepareVertices(Vertex &vType, int nverts);
  void Init();
  void ReadPlyFile(FILE *file);
  void ImportSinglePly(FILE *file, class world *world);
  void ImportPly(class file *file, class world *world);
  void AddVertex(Vertex &v);
  void AddFace(Face &f);

public:
  importer();

  // see XRML/base/importer.H
  class importer* instantiate(class file* file_handle =0);
  bool parse(class world* world, char **strpool);
};

}  // namespace ply

#endif /*_PLY_IMPORTER_H_*/
