// importer.H: import filter template

#ifndef _TOY_IMPORTER_H_
#define _TOY_IMPORTER_H_

// This include file gets installed
// in a sub-directory of the main include file directory, e.g. if
// the main include file directory is <path>/include, then this file
// shall be installed in <path>/include/toy/importer.H.
//
// Compile the import filter with:
//
//   <C++ compiler> -I<path>/include/toy -I<path>/include ...
//
// In this way, ../importer.H will be the base importer.H.
//
// Note: the Makefile in this directory takes care that it all works.
// Copy it and change the name "toy" to something of your own.

// Include base importer.H file (containing the xrml::importer base
// class.
#include "../importer.H"

// put the filters in this directory in their own name space
namespace toy {

// our importer shall be a child class of xrml::importer
class importer: public xrml::importer {
protected:
  // put all members for internal use here

public:
  // implement the virtual-declared members in xrml::importer:

  // This member function checks whether or not the importer class is
  // appropriate for parsing the specified file. If not, it returns
  // a null pointer. If appropriate, this functions returns a new
  // instance of the importer class.
  // If file_handle is null, just return a new importer object
  // of this class.
  xrml::importer* instantiate(class xrml::file* file_handle =0);

  // After instantiating an importer for a file, this member functions is
  // called from xrml::world->parse(). It parses the file desribed by the file
  // handle xrml::world->file (same handle as used for the instantiate() call).
  // The resulting scene graph is APPENDED to the following members of
  // the world object:
  // . sceneGraph (MFNode*)
  // . namedNodes (namedNodeTable) : table of named nodes (if any)
  // . protos (protoTable) : table of PROTO and EXTERNPROTO defined, if any.
  // After parsing, strpool shall point to a pool of strings read from 
  // the file (if applicable).
  bool parse(class xrml::world* world, char **strpool);
};

} // end namespace toy

#endif /* _TOY_IMPORTER_H_ */
