/* Box.H: Box nodes. */

#ifndef _Box_H_
#define _Box_H_

#include "vrml.H"
#include "Geometry.H"

#define BoxTypeId 	"Box"
extern bool IsBox(SFNode*);

class Box: public virtual SFNode, public Geometry {
private:
  //
  void validate_size(void);
  //
  void Box_clone(const Box&);
  
public:
  //
  Box();
  Box(const Box&);
  Box& operator=(const Box&);
  virtual ~Box();
  
  // state values
  SFVec3f          	size;
  
  //
  virtual SFNode* 	instantiate(Proto * =0);
  virtual double  	synchronize(void);
  virtual void    	render(void);
};

#endif /*_Box_H_*/
