/* Geometry.H: Geometry nodes. */

#ifndef _Geometry_H_
#define _Geometry_H_

#include "vrml.H"

#define GeometryTypeId 	"Geometry"
extern bool IsGeometry(SFNode*);

class Geometry: public virtual SFNode {
public:
  //
  Geometry();
  
  // state values
  SFBool           	ccw;
  MFInt32          	colorIndex;
  SFBool           	colorPerVertex;
  SFBool           	convex;
  MFInt32          	coordIndex;
  SFFloat          	creaseAngle;
  MFInt32          	normalIndex;
  SFBool           	normalPerVertex;
  SFBool           	solid;
  MFInt32          	texCoordIndex;
  
  //
  virtual void    	render(void);
};

#endif /*_Geometry_H_*/
