/* parser.H: VRML parser interface */

#ifndef _PARSER_H_
#define _PARSER_H_

#include "vrml.H"

/* Parses the file with given name and returns the sceneGraph of the world
 * found there. 'filname' can be a NULL pointer: in that case, the parser reads
 * from stdin. */
extern MFNode *VRMLParse(char *filename);

/* ------------------------------------------------------------------ */
/* routines for communication of informational, warning, error and fatal error
 * messages to the user of the library. The routines to be specified
 * have one char * parameter: the message being passed. */
typedef void (*VRML_MSG_CALLBACK_FUNC)(char *);

/* max. length of a message communicated by the VRML library. */
#define VRML_MAX_MESSAGE_LENGTH 1000

/* default informational message callback function is NULL: they are ignored. */
extern VRML_MSG_CALLBACK_FUNC VRMLSetInfoCallback(VRML_MSG_CALLBACK_FUNC func);

/* default warning and error message callback function print to stderr. */
extern VRML_MSG_CALLBACK_FUNC VRMLSetWarningCallback(VRML_MSG_CALLBACK_FUNC func);
extern VRML_MSG_CALLBACK_FUNC VRMLSetErrorCallback(VRML_MSG_CALLBACK_FUNC func);

/* default fatal error callback function prints the message and exits
 * the program with -1 return code. */
extern VRML_MSG_CALLBACK_FUNC VRMLSetFatalCallback(VRML_MSG_CALLBACK_FUNC func);

#endif /*_PARSER_H_*/
