// ray2vrml.C: convert rayshade file format to VRML'97

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "xrml.H"
#include "world.H"
#include "file.H"
#include "parser.H"

int main(int argc, char **argv)
{
  SetInfoCallback(printmsg);

  xrml::world *wrl = new xrml::world;
  importer* parser = new rayshade_parser;
  if (!wrl->parse(argc<2 ? NULL : argv[1], 0., parser)) {
    return 1;
  }

  wrl->newframe();
  xrml::file fh;
  fh.open("(stdout)", "w", stdout, false);
  wrl->save(&fh);

  return 0;
}
