// parser2.C: non-automatically generated rayshade parser C++ code

#include "parser.H"

/* for reporting parse errors */
void rayshade_parser::yyerror(char *s)
{
  xrml::current_linenr = yylineno;	// make sure we have correct line nr.
  Fatal(1, NULL, "%s near '%s'", s, yytext);
}

rayshade_context::rayshade_context()
{
  world = new MFNode(1);
  transform = Mat4();  // identity transform
  aggregate = 0;
}

rayshade_context::~rayshade_context()
{
  // needs nothing to do (certainly not delete 'world')
}

void rayshade_context::reset(void)
{
  transform = Mat4();
}

bool rayshade_parser::parse(class world *w, char **strpoolptr)
{
  world = w;
  fh = world->file;
  sbuf = strpoolptr;

  // global context
  ctx = new rayshade_context;

  xrml::current_filename = world->filename;
  xrml::current_linenr = yylineno = 1;
  yyparse();

  world->sceneGraph = ctx->world;
  return true;
}

void rayshade_parser::NotConverted(char* item)
{
  Info(NULL, "%s: item not (yet) converted", item);
}

void rayshade_parser::NotImplemented(char* item)
{
  Warning(item, "not yet implemented");
}

class SFNode* rayshade_parser::NewPrimitiveObject(class SFNode* primitive)
{
  return 0;
}

class SFNode* rayshade_parser::NewAggregateObject(class SFNode* aggregate)
{
  return 0;
}

class SFNode* rayshade_parser::NewNamedObject(class SFNode* named)
{
  return 0;
}

void rayshade_parser::AddInstance(class SFNode* object)
{
  if (object) ctx->world->append(object);
  ctx->reset();
}

void rayshade_parser::DefineNamedObject(char* name, class SFNode* object)
{
  NotImplemented("DefineNamedObject");
}

class SFNode* rayshade_parser::LookupNamedObject(char* name)
{
  NotImplemented("LookupNamedObject");
  return 0;
}

SFNode* rayshade_parser::NewHeightField(char *filename)
{
  NotConverted("heightfield");
  return (SFNode*)0;
}

SFNode* rayshade_parser::NewPoly(MFVec3f* points)
{
  NotConverted("poly");
  return (SFNode*)0;
}

SFNode* rayshade_parser::NewCone(const float radbottom, 
				 const Vec3d& bottom,
				 const float radtop,
				 const Vec3d& top)
{
  NotConverted("cone");
  return (SFNode*)0;
}

SFNode* rayshade_parser::NewCylinder(const float radius,
				     const Vec3d& bottom,
				     const Vec3d& top)
{
  NotConverted("cylinder");
  return (SFNode*)0;
}

SFNode* rayshade_parser::NewSphere(const float radius,
				   const Vec3d& center)
{
  NotConverted("sphere");
  return (SFNode*)0;
}

SFNode* rayshade_parser::NewDisc(const float radius,
				 const Vec3d& center,
				 const Vec3d& normal)
{
  NotConverted("poly");
  return (SFNode*)0;
}

SFNode* rayshade_parser::NewBox(const Vec3d& corner1,
				const Vec3d& corner2)
{
  NotConverted("box");
  return (SFNode*)0;
}

SFNode* rayshade_parser::NewFlatTriangle(const Vec3d& p1,
					 const Vec3d& p2,
					 const Vec3d& p3)
{
  NotConverted("trianglr");
  return (SFNode*)0;
}

SFNode* rayshade_parser::NewSmoothTriangle(const Vec3d& p1,
					 const Vec3d& n1,
					 const Vec3d& p2,
					 const Vec3d& n2,
					 const Vec3d& p3,
					 const Vec3d& n3)
{
  NotConverted("trianglr");
  return (SFNode*)0;
}

SFNode* rayshade_parser::NewTexturedTriangle(const Vec3d& p1,
					     const Vec3d& n1,
					     const Vec2d& uv1,
					     const Vec3d& p2,
					     const Vec3d& n2,
					     const Vec2d& uv2,
					     const Vec3d& p3,
					     const Vec3d& n3,
					     const Vec2d& uv3)
{
  NotConverted("triangleuv");
  return (SFNode*)0;
}

SFNode* rayshade_parser::NewPlane(const Vec3d& p, const Vec3d& n)
{
  NotConverted("plane");
  return (SFNode*)0;
}

SFNode* rayshade_parser::NewTorus(const float rmajor,
				  const float rminor,
				  const Vec3d& center,
				  const Vec3d& up)
{
  NotConverted("torus");
  return (SFNode*)0;
}

SFNode* rayshade_parser::NewBlob(void)
{
  NotConverted("blob");
  return (SFNode*)0;
}

void rayshade_parser::NewList(void)
{
  NotConverted("list");
}

void rayshade_parser::NewCSGUnion(void)
{
  NotConverted("union");
}

void rayshade_parser::NewCSGIntersect(void)
{
  NotConverted("intersect");
}

void rayshade_parser::NewCSGDifference(void)
{
  NotConverted("difference");
}

SFNode* rayshade_parser::EndAggregate(void)
{
  return (SFNode*)0;
}

