/* adapted for inclusion in the VRML library by Philippe Bekaert,          */
/* february 2001                                                           */

/* yacc.y								   */
/*									   */
/* Copyright (C) 1989, 1991, Craig E. Kolb				   */
/* All rights reserved.							   */
/*									   */
/* This software may be freely copied, modified, and redistributed,	   */
/* provided that this copyright notice is preserved on all copies.	   */
/*									   */
/* You may not distribute this software, in whole or in part, as part of   */
/* any commercial product without the express consent of the authors.	   */
/* 									   */
/* There is no warranty or other guarantee of fitness of this software	   */
/* for any purpose.  It is provided solely "as is".			   */
/* $Id: yacc.y,v 1.1 2001/02/22 21:07:06 philippe Exp $ */
%{
#include <stdlib.h>
#include <stdio.h>

static void yyerror(char *s);

char yyfilename[BUFSIZ];			/* Input filename */
extern FILE *yyin;				/* input file pointer */
extern int yylineno;				/* Current line # in file */
%}
%union {
	char *c;
	int i;
	float d;
}
%token <d> tFLOAT
%token <c> tSTRING tFILENAME
%token tAPERTURE tAPPLYSURF
%token tBACKGROUND tBLOB tBLOTCH tBOX tBUMP tCONE tCYL tDIRECTIONAL tCURSURF
%token tEXTENDED tEYEP tFBM tFBMBUMP tFOCALDIST tFOG tFOGDECK tFOV tGLOSS tGRID
%token tHEIGHTFIELD tLIGHT tLIST tLOOKP tMARBLE tMAXDEPTH tMIST
%token tJITTER tNOJITTER tDEFINE
%token tOBJECT tOUTFILE  tSKY tDISC tDIFFERENCE tUNION tINTERSECT
%token tPLANE tPOINT tPOLY tROTATE tSPOT tPRINT
%token tSCALE tSCREEN tSPHERE tSURFACE
%token tTHRESH tTRANSLATE tTRANSFORM tTRIANGLE tTRIANGLEUV tUP tEND
%token tTEXTURE tCHECKER tWOOD tCONTRAST tCUTOFF tCLOUD
%token tAMBIENT tDIFFUSE tREFLECT tTRANSP tSPECULAR tSPECPOW
%token tINDEX tATMOSPHERE tNOSHADOW tAREA tTRANSLU tTORUS
%token tEYESEP tSHADOWTRANSP tREPORT tVERBOSE tQUIET tWINDOW tCROP tSTRIPE
%token tMAP tUV tSPHERICAL tCYLINDRICAL tPLANAR
%token tIMAGE tSMOOTH tCOMPONENT tTEXTSURF tRANGE tTILE tSTARTTIME tFRAMELENGTH
%token tNAME tFILTER tGAUSS tBODY tSAMPLE tEXTINCT tWINDY tMOUNT
%token tSHUTTER tFRAMES
%left '+' '-'
%left '*' '/' '%'
%left UMINUS
%right '^'
%%
Items		: /* empty */
		| Items Item
		;
Item		: Eyep
		| Lookp
		| Up
		| Fov
		| Screen
		| Window
		| Crop
		| Report
		| Aperture
		| Focaldist
		| Eyesep
		| Maxdepth
		| Sample
		| Filter
		| Contrast
		| Cutoff
		| Background
		| Shadowtransp
		| Light
		| SurfDef
		| CurSurf
		| Outfile
		| Instance
		| NameObject
		| GlobalEffects
		| Define
		| Frames
		| Starttime
		| Shutter
		| Framelength
    		| Print
		;
Instance	: TransTextObj
                ;
TransTextObj	: TransObj Textures
		;	
TransObj	: Object Transforms
		;
Object		: ObjType
		| NamedObject
		;
ObjType		: Primitive
		| Aggregate
		;
Primitive	: PrimType
		;
PrimType	: Plane
		| Sphere
		| Box
		| Triangle
		| Cylinder
		| Cone
		| Poly
		| HeightField
		| Disc
		| Torus
		| Blob
		;
NameObject	: tNAME tSTRING TransTextObj
		;
Aggdefs		: Aggdefs Aggdef
		|
		;
Aggdef		: Instance
		| SurfDef
		| CurSurf
		| NameObject
		;
Textures	: Textures Texture
		|
		;
Texture		: tTEXTURE Texturetype Transforms
		;
Texturetype	: tCHECKER Surface
		| tBLOTCH Expr Surface
		| tBUMP Expr
		| tMARBLE
		| tMARBLE Filename
		| tFBM Expr Expr Expr Expr IExpr Expr
		| tFBM Expr Expr Expr Expr IExpr Expr Filename
		| tFBMBUMP Expr Expr Expr Expr IExpr 
		| tWOOD
		| tGLOSS Expr 
		| tCLOUD Expr Expr Expr IExpr Expr Expr Expr
		| tSKY Expr Expr Expr IExpr Expr Expr
		| ImageText
		| tSTRIPE Surface Expr Expr OptMapping
		| tWINDY Expr Expr Expr Expr IExpr Expr Expr Expr
		| tMOUNT Filename Expr Expr
		;
ImageText	: ImageTextType ImageTextOptions
		;
ImageTextType	: tIMAGE Filename
		;
ImageTextOptions: ImageTextOptions ImageTextOption
		| /* EMPTY */
		;
ImageTextOption: tCOMPONENT SurfCompName
		| tTILE Expr Expr
		| tTEXTSURF Surface
		| tRANGE Expr Expr
		| tSMOOTH
		| Mapping
		;
NamedObject	: tOBJECT Surface tSTRING
		| tOBJECT tSTRING
		;
Transforms	: Transforms PostTransform
		| /* empty */
		;
PostTransform	: TransformType
		;
TransformType	: tSCALE AnimExpr AnimExpr AnimExpr
		| tTRANSLATE AnimExpr AnimExpr AnimExpr
		| tROTATE AnimExpr AnimExpr AnimExpr AnimExpr
		| tTRANSFORM	AnimExpr AnimExpr AnimExpr
				AnimExpr AnimExpr AnimExpr
				AnimExpr AnimExpr AnimExpr
		| tTRANSFORM	AnimExpr AnimExpr AnimExpr
				AnimExpr AnimExpr AnimExpr
				AnimExpr AnimExpr AnimExpr
				AnimExpr AnimExpr AnimExpr
		;
Eyep		: tEYEP Vector Transforms
		;
Lookp		: tLOOKP Vector
		;
Up		: tUP Vector
		;
Fov		: tFOV Expr Expr
		| tFOV Expr
		;
Sample		: tSAMPLE IExpr tJITTER
		| tSAMPLE IExpr tNOJITTER
		| tSAMPLE IExpr
		;
Filter		: tFILTER tBOX Expr
		| tFILTER tBOX
		| tFILTER tGAUSS Expr
		| tFILTER tGAUSS
		;
Starttime	: tSTARTTIME Expr
		;
Frames		: tFRAMES IExpr
		;
Framelength	: tFRAMELENGTH Expr
		;
Shutter		: tSHUTTER Expr
		;
Contrast	: tCONTRAST Expr Expr Expr
		;
Cutoff		: tCUTOFF Intensity
		;
Screen		: tSCREEN IExpr IExpr 
		;
Window		: tWINDOW IExpr IExpr IExpr IExpr
		;
Crop		: tCROP Expr Expr Expr Expr
		;
Report		: tREPORT Verbose Quiet IExpr Filename
		| tREPORT Verbose Quiet IExpr
		| tREPORT Verbose Quiet Filename
		| tREPORT Verbose Quiet
		;
Verbose		: tVERBOSE
		|
		;
Quiet		: tQUIET
		|
		;
Aperture	: tAPERTURE Expr
		;
Focaldist	: tFOCALDIST Expr
		;
Eyesep		: tEYESEP Expr
		;
Maxdepth	: tMAXDEPTH IExpr
		;
Background	: tBACKGROUND Color
		;
Shadowtransp	: tSHADOWTRANSP
		;
Light		: LightType
		| LightType tNOSHADOW
		| tLIGHT Intensity tAMBIENT
		| Lightdef tAREA Vector Vector IExpr Vector IExpr
		| Lightdef tAREA Vector Vector IExpr Vector IExpr tNOSHADOW
		;
LightType	: Lightdef tPOINT Vector
		| Lightdef tDIRECTIONAL Vector
		| Lightdef tEXTENDED Expr Vector
		| Lightdef tSPOT Vector Vector Expr
		| Lightdef tSPOT Vector Vector Expr Expr Expr
		;
Lightdef	: tLIGHT Intensity
		;
CurSurf		: tAPPLYSURF Surface
		;
OptSurface	: Surface
		| /* EMPTY */
		;
Surface		: NamedSurf
		| ModifyNamedSurf
		| SurfSpec
		;
NamedSurf	: tSTRING {}
		| tCURSURF
		;
ModifyNamedSurf : CopyNamedSurf SurfComponent SurfComponents
		| CopyCurSurf SurfComponent SurfComponents
		;
CopyNamedSurf	: tSTRING {}
		;
CopyCurSurf	: tCURSURF
		;
SurfSpec	: SurfComponent SurfComponents
		;
SurfDef		: tSURFACE tSTRING Surface
		| tSURFACE tSTRING
		;
SurfComponents	: SurfComponents SurfComponent
		| /* EMPTY */
		;
SurfComponent	: Ambient
		| Diffuse
		| Specular
		| Specpow
		| Body
		| Reflect
		| Transp
		| Extinct
		| Index
		| Translu
		| Noshadow
		;
Ambient		: tAMBIENT Color
		;
Diffuse		: tDIFFUSE Color
		;
Specular	: tSPECULAR Color
		;
Body		: tBODY Color
		;
Extinct		: tEXTINCT Expr
		;
Specpow		: tSPECPOW Expr
		;
Reflect		: tREFLECT Expr
		;
Transp		: tTRANSP Expr
		;
Index		: tINDEX Expr
		;
Translu		: tTRANSLU Expr Color Expr
		;
Noshadow	: tNOSHADOW
		;
HeightField	: tHEIGHTFIELD Surface Filename
		| tHEIGHTFIELD Filename
		;
Poly		: tPOLY OptSurface Polypoints
		;
Polypoints	: /* empty */
		| Polypoints Polypoint
		;
Polypoint	: Vector
		;
Aggregate	: AggregateDef
		;
AggregateDef	: AggregateCreate Aggdefs tEND
		;
AggregateCreate	: AggregateType
		;
AggregateType	: List
		| Grid
		| Csg
		;
List		: tLIST
		;
Grid		: tGRID IExpr IExpr IExpr
		;
Csg		: CombineOp
		;
CombineOp	: tUNION
		| tINTERSECT
		| tDIFFERENCE
    		;
Cone		: tCONE OptSurface Expr Vector Expr Vector
		;
Cylinder	: tCYL OptSurface Expr Vector Vector
		;
Sphere		: tSPHERE OptSurface Expr Vector
		;
Disc		: tDISC OptSurface Expr Vector Vector
		;
Box		: tBOX OptSurface Vector Vector
		;
Triangle	: tTRIANGLE OptSurface Vector Vector Vector
		| tTRIANGLE OptSurface  Vector Vector
					Vector Vector
					Vector Vector
		| tTRIANGLEUV OptSurface Vector Vector Vec2d
					 Vector Vector Vec2d
					 Vector Vector Vec2d
		;
Plane		: tPLANE OptSurface Vector Vector
		;
Torus		: tTORUS OptSurface Expr Expr Vector Vector
		;
Blob		: tBLOB OptSurface Expr MetaPoints
		;
MetaPoints	: /* empty */
		| MetaPoints MetaPoint
		;
MetaPoint	: Expr Expr Expr Expr Expr
		;
Outfile		: tOUTFILE Filename
		;
GlobalEffects	: tATMOSPHERE Effects
		| tATMOSPHERE IExpr Effects
		;
Effects		: Effects Effect
		|
		;
Effect		: EffectType
		;
EffectType	: tMIST Color Color Expr Expr
		| tFOG Color Color
		| tFOGDECK Expr Expr Vector Expr IExpr Color Color
		;
Color		: Expr Expr Expr
		;
Vector		: Expr Expr Expr
		;
Vec2d		: Expr Expr 
		;
OptMapping	: Mapping
		| /* EMPTY */
		;
Mapping		: tMAP MapMethod
		;
MapMethod	: tUV
		| tSPHERICAL
		| tSPHERICAL Vector Vector Vector
		| tCYLINDRICAL
		| tCYLINDRICAL Vector Vector Vector
		| tPLANAR
		| tPLANAR Vector Vector Vector
		;
SurfCompName	: tAMBIENT
		| tDIFFUSE
		| tBODY
		| tSPECULAR
		| tREFLECT
		| tTRANSP
		| tSPECPOW
		| tBUMP
		| tINDEX
		;
Intensity	: Expr
		| Color
		;
Print		: tPRINT Expr
                ;
Define		: tDEFINE tSTRING AnimExpr
		;
IExpr		: Expr
		;
Expr		: Float
		| ParenExpr
		;
AnimExpr	: Float
		| ParenExpr
		;
ParenExpr	: '(' MExpr ')'
		;
MExpr		: tFLOAT {}
                | tSTRING {}
		| Symtabent '(' MExpr ')'
		| Symtabent '(' MExpr ',' MExpr ')'
		| Symtabent '(' MExpr ',' MExpr ',' MExpr ')'
		| Symtabent '(' MExpr ',' MExpr ',' MExpr ',' MExpr ')'
		| Symtabent
			'(' MExpr ',' MExpr ',' MExpr ',' MExpr ',' MExpr ')'
		| '(' MExpr ')'
		| MExpr '+' MExpr
		| MExpr '-' MExpr
		| MExpr '*' MExpr
		| MExpr '/' MExpr
		| MExpr '%' MExpr
		| '-' MExpr %prec UMINUS
		| '+' MExpr %prec UMINUS
		| MExpr '^' MExpr
		;
Float		: tFLOAT {}
                | '-' tFLOAT {}
                | '+' tFLOAT {}
		;
Filename	: tSTRING {}
                | tFILENAME {}
		;
Symtabent	: tSTRING {}
		;
%%
/*
 * Issue error message containing filename and line number, and exit.
 */
static void yyerror(char *s)
{
  fprintf(stderr,"Error: %s: line %d: %s\n", yyfilename, yylineno, s);
  exit(1);
}
