// scanner.H: rayshade flex C++ scanner

#ifndef _RAYSHADE_SCANNER_H_
#define _RAYSHADE_SCANNER_H_

#include <stdio.h>
#include "file.H"

using namespace xrml;

// rayshade data types
// we can't use Vec3 because it's not allowed in the YYSTYPE
// union (constructors ...)
struct Vector {
  float x, y, z;
};

struct Vec2d {
  float u, v;
};

struct Color {
  float r, g, b;
};

#include "tokens.H"

#ifndef _RAYSHADE_SCANNER_SOURCE_
#define yyFlexLexer rayFlexLexer
#include "FlexLexer.h"
#endif

class rayshade_scanner: public rayFlexLexer {
protected:
  char **sbuf;

  int LexerInput(char *buf, int max_size);
  char *strsave(char*);
  void skipcomments(void);
  void handlehash(void);

public:
  class file *fh;

  void init(class file *handle =0)
  {
    fh = handle;
  }

  rayshade_scanner()
  {
    init(0);
  }

  int yylex(YYSTYPE *lvalp);

  virtual void yyerror(char *s);
};

#endif /* _RAYSHADE_SCANNER_H_ */
