/* main.C: toy filter test program - really a toy */

#include <iostream.h>
#include <stdlib.h>
#include "world.H"
#include "toy/importer.H"
#include "toy/exporter.H"

int main(int argc, char **argv)
{
  // Create a world object to hold the scene
  // to be parsed and rendered and whatever.
  // (This shall always be the first step.)
  xrml::world *wrl = new xrml::world;

  // Create a toy import filter and import a scene graph using it.
  cerr << "Importing a scene graph using the toy importer ...\n";
  xrml::importer *toy_importer = new toy::importer;
  if (!wrl->parse((char*)0,        /* file name, null = stdin */
		  0.,              /* start time */
		  toy_importer)) { /* import filter to use */
    cerr << "Toy import filter failed!!\n";
    exit(1);
  }
  delete toy_importer;  // toy importer is no longer needed

  // Write the parsed world to stdout, in default VRML V2.0 utf8
  // format.
  cerr << "Exporting scene graph in default (vrml'97) file format ...\n";
  wrl->save();

  // And also using toy export filter:
  cerr << "Exporting using the toy export filter ...\n";
  xrml::exporter *toy_exporter = new toy::exporter;
  wrl->save((char*)0 /* stdout */ , toy_exporter);
  delete toy_exporter;

  cerr << "done.\n";

  return 0;
}

