/* canvas.h: handles mouse and expose events and cursor shape in the canvas 
 * window. */

#ifndef _CANVAS_H_INCLUDED_
#define _CANVAS_H_INCLUDED_

#ifdef __cplusplus
extern "C" {
#endif

#include <Xm/Xm.h>

extern Widget CreateCanvasWindow(Widget parent);

/* initializes event handling and cursor shape on the canvas widget */
extern void CanvasInit(Widget canvas);

/* handles canvas window resize events */
extern void CanvasResizeCallback(Widget canvas, XtPointer client_data, XtPointer call_data);

/* handles canvas window expose events */
extern void CanvasExposeCallback(Widget canvas, XtPointer client_data, XtPointer call_data);

/* handles mouse events on the canvas window */
extern void CanvasMouseEvent(Widget canvas, XtPointer client_data, XEvent *event);

/* handles canvas key events */
extern void CanvasKeyEvent(Widget canvas, XtPointer client_data, XEvent *event);

/* canvas modes: canvas modes determine what cursor shape will be used on the 
 * canvas window and how the program will react on mouse events. */

/* Moving the mouse while pressing one of the buttons updates the camera. 
 * The cursor shape is the default cursor. This mode is used when the program is
 * not busy computing or rendering and when not selecting a patch. It is the
 * default canvas mode set when calling CanvasInit(). */
#define CANVASMODE_NORMAL	1

/* Moving the mouse while pressing one of the mouse buttons updates the camera,
 * the a clock cursor is shown instead of the default (arrow) cursor. This mode
 * is used to indicate that computations are going on. */
#define CANVASMODE_WORKING	2	

/* This mode is used to select a patch. The cursor shown is a crosshair cursor.
 * When the first mouse button is pressed and then released, the patch seen through the
 * pixel at the current mouse position is selected. Another mouse button will cancel
 * the selection. */
#define CANVASMODE_SELECT_PATCH	3

/* A spraycan cursor is shown. This mode indicates that the scene is being 
 * rendered. Mouse events are ignored during rendering. */
#define CANVASMODE_RENDER	4

/* Saves the current canvas mode and sets a new */
extern void CanvasPushMode(int canvasmode);

/* restores the previous canvas mode */
extern void CanvasPullMode(void);

/* returns the current canvas mode. */
extern int CanvasGetMode(void);

/* Takes care of possible expose events immediately: if the scene needs to be
 * redrawn, this routine removes the installed redraw work procedure and immediately
 * rerenders the scene. A redraw work procedure is used for expose event compression:
 * Normally, the scene is redrawn in the background, after all pending events have been
 * processed. */
extern void CanvasRedraw(void);

#ifdef __cplusplus
}
#endif

#endif /*_CANVAS_H_INCLUDED_*/
