/* error.h: afdrukken van waarschuwingen, fouten, fatale fouten  */

#ifndef _ERROR_H_
#define _ERROR_H_

#ifdef __cplusplus
extern "C" {
#endif

#ifndef NULL
#define NULL (char *)0
#endif /*NULL*/

#ifndef FALSE
#define FALSE 0
#endif /*FALSE*/

#ifndef TRUE
#define TRUE 1
#endif /*TRUE*/

/* drukt een foutenboodschap af.
 * argumenten: naam van de routine waar de fout gebeurde, of NULL indien niet
 * relevant en de rest zoals printf */
extern void Error(char *routine, char *text, ...);

/* drukt een waarschuwing af */
extern void Warning(char *routine, char *text, ...);

/* 
 * Drukt een fatale foutenboodschap af en beeindigt het programma. 
 * eerste argument is een foutencode waarmee het programma verlaten moet 
 * worden. Conventie: errcode < 0 ===> fout in het programma.
 * 
 * Foutencodes:
 *	-1: een onmogelijke situatie doet zich voor 
 *	-2: een datastructuur lijkt om zeep 
 *
 *       1: fouten bij het (re)alloceren van geheugen
 */
extern void Fatal(int errcode, char *routine, char *text, ...);

/* geeft FALSE terug indien er geen fouten gebeurd zijn sinds de laatste
 * oproep naar deze funtie en TRUE anders. */
extern int ErrorOccurred(void);

/* stel toestand "geen fouten gebeurd" in */
extern void ErrorReset(void);

/* Assert
 * Met assert kan je testen in je programma plaatsen, die als ze
 * niet voldaan zijn een core dumpen (debug) of Fatal oproepen (non debug)
 */

#ifdef DEBUGASSERTS
#define Assert(test, message) \
if(!(test)) { Error(NULL, \
              message " in file : " __FILE__ " line : %i\n",__LINE__); \
              abort(); \
          }
#else
#define Assert(test, message) \
if(!(test)) Fatal(-1, NULL, \
                  message " in file :" __FILE__ " line : %i\n",__LINE__);
#endif


#ifdef __cplusplus
}
#endif

#endif /*_ERROR_H_*/
