// oglrenderer.H: A VRML "renderer" subclass for rendering with OpenGL.

#ifndef _OGLRENDERER_H_
#define _OGLRENDERER_H_

#include "renderer.H"

#include "Viewpoint.H"
#include "WorldInfo.H"
#include "NavigationInfo.H"
#include "Array.H"

using namespace xrml;

class opengl_renderer: public renderer {
  int stripsize, lastnrverts;	// current nr of vertices in begin-end strip 
  Vec3 gmin, gmax;		// current grouping node bounding box
  int nrlights;			// current number of lights that are ON
  int load_Texture(int width, int height, int numcomponents, unsigned char* image, bool repeatS, bool repeatT);
  bool texture_active, lighting_active;
  int current_texture_components;
  float current_alpha;

public:
  bool use_dlists;              // display list usage change tracker
  bool first_frame;
  bool enable_headlight;
  bool disable_textures;
  bool draw_outlines;
  Vec3 min, max;		// world bounding box
  Viewpoint *default_view;	// first Viewpoint node in scene graph
  array<Viewpoint*> views;	// list of all Viewpoint nodes
  WorldInfo *winfo;		// model info
  NavigationInfo *ninfo;	// navigation info
  int dynamicBackfaceCulling;	// do dynamic backface culling or not?

  // general
  void begin_frame(class world *);
  void end_frame(class world *);

  void worldInfo(WorldInfo *);

  // bindables
  void viewpoint(Viewpoint *);
  void navigationInfo(class NavigationInfo *);

  // grouping and transforms
  void begin_Grouping(Grouping *);
  void end_Grouping(Grouping *);
  void begin_Transforming(Transforming *);
  void end_Transforming(Transforming *);

  // shape
  void begin_Shape(Shape *);

  // materials
  void begin_Material(Material *);
  void end_Material(Material *);
  void begin_Texture(Texture *);
  void end_Texture(Texture *);
  void begin_TextureTransform(TextureTransform *);
  void end_TextureTransform(TextureTransform *);

  // light sources
  virtual void begin_LightSource(class LightSource *);
  virtual void end_LightSource(class LightSource *);
  virtual void begin_DirectionalLight(class DirectionalLight *);
  virtual void begin_PointLight(class PointLight *);
  virtual void begin_SpotLight(class SpotLight *);

  // geometry
  void geometry(Geometry *);
  void elevationGrid(ElevationGrid*);
  void indexedFaceSet(IndexedFaceSet*);

  // called by the default geometry handler renderer::geometry() 
  void begin_faces(Geometry *);
  void begin_face(int, int);
  void face_normal(int, const SFVec3f&);
  void face_color(int, const SFColor&);
  void vertex_coord(int, const SFVec3f&);
  void vertex_texCoord(int, const SFVec2f&);
  void vertex_normal(int, const SFVec3f&);
  void vertex_color(int, const SFColor&);
  void end_face(int, int);
  void end_faces(Geometry *);

  bool node_has_changed(SFNode*);
};

#endif /*_OGLRENDERER_H_*/
