/* ui.h: some global variables related to the graphics interface */

#ifndef _INTERFACE_H_
#define _INTERFACE_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <Xm/Xm.h>

/* application class name --- determines the name of the application defaults file
 * for the application. */
#define APP_CLASS_NAME			"ViewVRML"

/* the program detects the best X visual to use and creates a suitables
 * standard colormap for use with it automatically. visual.c
 * contains the routijnes to do the choice */
extern XVisualInfo best_visual;
extern Colormap cmap;

/* the X visual info is not correctly passed from parent to sub menus
 * with Motif 1.2, so we set it explicitely ourselves when creating
 * the submenus */
extern Arg visargs[3];
extern int nrvisargs;

/* X application context and some important widgets */
extern XtAppContext app_context;
extern Widget topLevel, canvas;
extern Display *display;

/* sets up the user interface and starts the application main loop. */
extern void StartUserInterface(int argc, char **argv);

/* external declarations of submenu creation functions. */
extern void CreateFileMenu(Widget menuBar);
extern void CreateRenderMenu(Widget menuBar);
extern void CreateHelpMenu(Widget menuBar);

extern void CreateCanvasPopupMenu(void);

extern void ProcessWaitingEvents(void);
extern void CheckForEvents(void);

/* ui_file.c */
extern void SetModelInfo(char *info);

/* in main.C */
extern void ReadScene(int nfiles, char **fnames);
extern void RenderScene(void);
extern void SetDefaultView(void);
extern void SetBackfaceCulling(int mode);
extern double get_time(void);

#ifdef __cplusplus
}
#endif

#endif /*_INTERFACE_H_*/
