// ui_render.C: render submenu

#include "ui.h"
#include "uit.h"
#include "render.h"

static void BCCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
  int set = (((XmToggleButtonCallbackStruct *)call_data)->set == XmSET);
  if (set)
    SetBackfaceCulling(*(BACKFACECULLINGMODE*)client_data);
}

static void CreateBackfaceCullingMenu(Widget parent)
{
  static BACKFACECULLINGMODE bc_on = BC_ON;
  static BACKFACECULLINGMODE bc_off = BC_OFF;
  static BACKFACECULLINGMODE bc_dynamic = BC_DYNAMIC;
  Widget menu = CreateSubMenu(parent, "backfaceCullingButton", "backfaceCullingMenu");

  XtVaSetValues(menu,
		XmNradioBehavior, True,
		NULL);

  CreateToggleButton(menu, "bcOnButton", renderopts.backface_culling == BC_ON ? True : False,
		     BCCallback, (XtPointer)&bc_on);
  CreateToggleButton(menu, "bcOffButton", renderopts.backface_culling == BC_OFF ? True : False,
		     BCCallback, (XtPointer)&bc_off);
  CreateToggleButton(menu, "bcDynamicButton", renderopts.backface_culling == BC_DYNAMIC ? True : False,
		     BCCallback, (XtPointer)&bc_dynamic);
}

static void DisableLightingCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
  int set = (((XmToggleButtonCallbackStruct *)call_data)->set == XmSET);
  renderopts.disable_lighting = set;
}
static void DisableTexturesCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
  int set = (((XmToggleButtonCallbackStruct *)call_data)->set == XmSET);
  renderopts.disable_textures = set;
}

static void EnableHeadlightCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
  int set = (((XmToggleButtonCallbackStruct *)call_data)->set == XmSET);
  renderopts.enable_headlight = set;
}

static void UseDisplayListsCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
  int set = (((XmToggleButtonCallbackStruct *)call_data)->set == XmSET);
  renderopts.use_display_lists = set;
}

static void DrawOutlinesCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
  int set = (((XmToggleButtonCallbackStruct *)call_data)->set == XmSET);
  renderopts.draw_outlines = set;
}

void CreateRenderMenu(Widget parent)
{
  Widget renderMenu = CreateSubMenu(parent, "renderButton", "renderMenu");
  CreateBackfaceCullingMenu(renderMenu);
  CreateToggleButton(renderMenu, "disableLightingButton",
		     renderopts.disable_lighting ? XmSET : XmUNSET,
		     DisableLightingCallback, (XtPointer)NULL);
  CreateToggleButton(renderMenu, "disableTexturesButton",
		     renderopts.disable_textures ? XmSET : XmUNSET,
		     DisableTexturesCallback, (XtPointer)NULL);
  CreateToggleButton(renderMenu, "enableHeadlightButton",
		     renderopts.enable_headlight ? XmSET : XmUNSET,
		     EnableHeadlightCallback, (XtPointer)NULL);
  CreateToggleButton(renderMenu, "useDisplayListsButton",
		     renderopts.use_display_lists ? XmSET : XmUNSET,
		     UseDisplayListsCallback, (XtPointer)NULL);
  CreateToggleButton(renderMenu, "drawOutlinesButton",
		     renderopts.draw_outlines ? XmSET : XmUNSET,
		     DrawOutlinesCallback, (XtPointer)NULL);
}
