// demonstrates construction of a MF* arrays out of SF* elements

#include "xrml.H"

using namespace xrml;

int main(int argc, char **argv)
{
  cerr << "Assigning elements individually ...\n";
  MFVec3f coords;
  coords.append(SFVec3f(0,0,0));
  coords.append(SFVec3f(0,1,0));
  coords.append(SFVec3f(1,0,0));
  coords.append(SFVec3f(1,1,1));
  cerr << "coords = " << coords << "\n";

  cerr << "Using an array of SFVec3f to initialise an MFVec3f ...\n";
  SFVec3f v[4] = { SFVec3f(0,0,0), SFVec3f(0,1,0), SFVec3f(1,0,0), SFVec3f(1,1,1) };
  // the array is copied during initialisation, so the 
  // original array can be deleted afterwards.
  MFVec3f coords2(4, v);
  cerr << "coords2 = " << &coords2 << "\n";

  cerr << "Initialising an MFVec3f with an array of XYZ floating point triples ...\n";
  float xyz_triples[12] = { 0., 0., 0.,   0., 1., 0.,   1., 0., 0.,   1., 1., 1. };
  MFVec3f coords3(4, (SFVec3f*)xyz_triples);
  cerr << "coords3 = " << &coords3 << "\n";

  cerr << "Doing the same, but without copying the array while initialising the MFVec3f object\n";
  float *xyz_triples2 = new float[12];
  memcpy(xyz_triples2, xyz_triples, 12*sizeof(float));
  MFVec3f coords4;
  // Make sure that the xyz_triples array is not destroyed during the
  // life time of the MFVec3f object !!!!
  // You also should only do this with arrays that have been
  // dynamically allocated, or you'll get a segmentation fault
  // when the MFVec3f object is deleted (when exiting the 
  // program e.g.)
  coords4.set(4, (SFVec3f*)xyz_triples2);
  cerr << "coords4 = " << &coords3 << "\n";

  cerr << "Trying to create an MFInt32 aray using an array of constant integers ...\n";
  SFInt32 i[8] = { 1, 2, 3, 4, 5, 6, 7, 8 };
  MFInt32 indices(8, i);
  cerr << "indices = " << &indices << "\n";

  cerr << "Appending additional elements to 'indices' ... \n";
  SFInt32 newi[4] = {9, 10, 11, 12 };
  indices.append(4, newi);
  cerr << "indices = " << &indices << "\n";

  // You can do the latter more effiicently however:
  // The indices array will be dynamically resized from 8
  // to 8+4 = 12 elements in the example above. If you know
  // in advance how many elements you will need, but still
  // want to append them not all at once, you can proceed as
  // follows:
  cerr << "Doing the same, but avoiding dynamic resizing ...\n";
  MFInt32 indices2(12);  // make array with space for 12 elements
  // (you can't pass the i array in the constructor above 
  // as it has only 8 elements.)
  indices2.append(8, i);
  indices2.append(4, newi);  // no dynamic resize now
  cerr << "indices2 = " << &indices2 << "\n";

  return 0;
}
