/* PhB3DNoiseTexture.C: PhB3DNoiseTexture nodes (public source) */

#include "PhB3DNoiseTexture.H"
#include "PerlinNoise.H"
#include <math.h>

namespace xrml {

void PhB3DNoiseTexture::render(void)
{
  if (noiseInit == false) {
    noise = PerlinNoise(3);
    noiseInit = true;
  }
}

float *PhB3DNoiseTexture::values(const Vec3& point, int *nrChannels)
{
  float coord[3];
  if (nrChannels) *nrChannels = 2;

  // apply scaling
  coord[0] = (point.x * k) - floor(point.x * k);
  coord[1] = (point.y * k) - floor(point.y * k);
  coord[2] = (point.z * k) - floor(point.z * k);

  // generate noise
  value[0] = (noise.noise(coord) + 1) / 2;
  value[1] = 1 - value[0];

  return value;
}

}  // namespace xrml
