/* PhB3DSpiralTexture.C: PhB3DSpiralTexture nodes (public source) */

#include "PhB3DSpiralTexture.H"

namespace xrml {

void PhB3DSpiralTexture::render(void)
{
  Warning(NULL, "PhB3DSpiralTexture::render(): not yet implemented");
}

float *PhB3DSpiralTexture::values(const Vec3& point, int *nrChannels)
{
  static float w[2];
  Vec3 xfpt(point.x, point.y, 0); xfpt.normalize();
  float a = acos(xfpt.x);
  if (xfpt.y < 0.) a = 2. * M_PI - a;
  w[0] = (int)floor(point.z - 2.*a/(2*M_PI)) & 1;
  w[1] = 1. - w[0];
  *nrChannels = 2;
  return w;
}

}  // namespace xrml
