// PhB3DTexturedSurface.H: PhB3DTexturedSurface nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _PhB3DTexturedSurface_H_
#define _PhB3DTexturedSurface_H_

#include "xrml.H"
#include "PhBSurface.H"
#include "PhB3DTexture.H"
#include "PhB3DTextureTransform.H"

// utility includes
// end of utility includes

namespace xrml {
#define PhB3DTexturedSurfaceTypeId 	"PhB3DTexturedSurface"
extern bool IsPhB3DTexturedSurface(SFNode*);

class PhB3DTexturedSurface: public virtual SFNode, public PhBSurface {
private:
  //
  void clone_here(const PhB3DTexturedSurface&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    texture_updated = 0x1,
    surfaces_updated = 0x2,
    textureTransform3D_updated = 0x4 
  };
  
protected:
  // raw children nodes (can be PROTO) + synchronize methods:
  SFNode* 	_texture;
  void 	synchronize_texture(void);
  MFNode 	_surfaces;
  void 	synchronize_surfaces(void);
  SFNode* 	_textureTransform3D;
  void 	synchronize_textureTransform3D(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  PhB3DTexturedSurface();
  PhB3DTexturedSurface(const PhB3DTexturedSurface&);
  PhB3DTexturedSurface& operator=(const PhB3DTexturedSurface&);
  virtual ~PhB3DTexturedSurface();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  PhB3DTexture*    	texture;
  array<PhBSurface*> 	surfaces;
  PhB3DTextureTransform* 	textureTransform3D;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_texture(SFNode*);
  void             	set_surfaces(const MFNode&);
  void             	set_textureTransform3D(SFNode*);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_texture(SFNode*);
  bool             	assign_surfaces(const MFNode&);
  bool             	assign_textureTransform3D(SFNode*);
  
  // update status
  inline bool      	texture_is_updated(void) { return (status & texture_updated); }
  inline void      	texture_clear_update(void) { status &= ~texture_updated; }
  inline bool      	surfaces_is_updated(void) { return (status & surfaces_updated); }
  inline void      	surfaces_clear_update(void) { status &= ~surfaces_updated; }
  inline bool      	textureTransform3D_is_updated(void) { return (status & textureTransform3D_updated); }
  inline void      	textureTransform3D_clear_update(void) { status &= ~textureTransform3D_updated; }
  
  // utility members
  bool isLightSource(void);

  bool isScatterer(void);

  bool isTextured(void)
  {
    return true;
  }

  /*
  Spectrum evaluateEDF(const Vec3& point,
		       const Vec3& direction,
		       const Spectrum& specWeight,
		       int range,
		       float *pdf);
  Vec3 sampleEDF(const Vec3& point,
		 const Spectrum& specWeight,
		 float xi1, float xi2,
		 int range,
		 Spectrum *value, float *pdf);
  Spectrum emittance(const Vec3& point, int range);
  */

  Spectrum evaluateBSDF(const Vec3& point, const Vec3& texco, const Vec3& texco3d,
			const Vec3& inDir,
			const Vec3& outDir,
			const Spectrum& inSpec,
			const complex& indexIn,
			const complex& indexOut,
			int modes, 
			float *pdf);

  Vec3 sampleBSDF(const Vec3& point, const Vec3& texco, const Vec3& texco3d,
		  const Vec3& inDir,
		  const Spectrum& inSpec,
		  const complex& indexIn,
		  const complex& indexOut,
		  float xi1, float xi2, 
		  int modes,
		  Spectrum *value, float *pdf);

  Spectrum albedo(const Vec3& point, const Vec3& texco, const Vec3& texco3d,
		  const Vec3& inDir,
		  const complex& indexIn,
		  const complex& indexOut,
		  int modes);

protected:
  Vec3 get_texcoord(const Vec3& point, const Vec3& texco);
  
  inline void util_init(void) { }
  inline void util_clone(const PhB3DTexturedSurface& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_PhB3DTexturedSurface_H_*/
