// PhBBackground.H: PhBBackground nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _PhBBackground_H_
#define _PhBBackground_H_

#include "xrml.H"
#include "Bindable.H"

// utility includes
#include "vector.H"
#include "spectrum.H"
// end of utility includes

namespace xrml {
#define PhBBackgroundTypeId 	"PhBBackground"
extern bool IsPhBBackground(SFNode*);

class PhBBackground:  public Bindable {
public:
  //
  virtual int major_version(void), minor_version(void);
  virtual bool is_leaf_class(void);
  
  PhBBackground();
  
  //
  virtual void     	render(void);
  
  // eventIns:
  virtual void     	set_bind(const SFBool&);
  
  // eventOuts:
  //  SFBool            	isBound;
  virtual void     	post_isBound(const SFBool& val);
  
  // update status
  virtual bool     	isBound_is_updated(void);
  virtual void     	isBound_clear_update(void);
  
  // utility members
  
  // Evaluate spectral radiance [W/m^2sr/m] coming in from the given
  // direction towards the background.
  // If pdf is not null, also computes the probability of sampling the given
  // direction taking into account specWeight, a spectral weight.
  virtual Spectrum eval(const Vec3& position, const Vec3& direction,
			const Spectrum& specWeight, float *pdf);

  // Samples a direction towards the background, taking into account the
  // radiance coming in from the background and the spectral weight.
  // Directions in a full sphere can be returned.
  // If value or pdf is not null, also the spectral radiance and probabiliy
  // of the returned direction are computed on the fly.
  virtual Vec3 sample(const Spectrum& specWeight, const Vec3& position, 
		      const float xi1, const float xi2,
		      Spectrum *value, float *pdf);

  // Computes the integral over the full sphere of the background radiance
  // (= total spectral energy [W/m] emitted by the background)
  virtual Spectrum power(const Vec3& position);

protected:
  inline void util_init(void) { }
  inline void util_clone(const PhBBackground& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_PhBBackground_H_*/
