// PhBBackgroundLight.H: PhBBackgroundLight nodes.

// This file has been generated using nodegen 0.51.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _PhBBackgroundLight_H_
#define _PhBBackgroundLight_H_

#include "xrml.H"
#include "PhBBackground.H"
#include "Children.H"
#include "PhBSpectrum.H"

// utility includes
// end of utility includes

namespace xrml {
#define PhBBackgroundLightTypeId 	"PhBBackgroundLight"
extern bool IsPhBBackgroundLight(SFNode*);

class PhBBackgroundLight: public virtual SFNode, public PhBBackground, public Children {
private:
  //
  void clone_here(const PhBBackgroundLight&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    isBound_updated = 0x1,
    spectralBasis_updated = 0x2,
    spectralWeights_updated = 0x4,
    orientation_updated = 0x8,
    angle_updated = 0x10 
  };
  
protected:
  // raw children nodes (can be PROTO) + synchronize methods:
  MFNode 	_spectralBasis;
  void 	synchronize_spectralBasis(void);

  // raw eventOut posting:
  void post_isBound(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  PhBBackgroundLight();
  PhBBackgroundLight(const PhBBackgroundLight&);
  PhBBackgroundLight& operator=(const PhBBackgroundLight&);
  virtual ~PhBBackgroundLight();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  array<PhBSpectrum*> 	spectralBasis;
  MFFloat          	spectralWeights;
  SFRotation       	orientation;
  SFFloat          	angle;
  
  // eventIns:
  void             	set_bind(const SFBool&);
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_spectralBasis(const MFNode&);
  void             	set_spectralWeights(const MFFloat&);
  void             	set_orientation(const SFRotation&);
  void             	set_angle(const SFFloat&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_spectralBasis(const MFNode&);
  bool             	assign_spectralWeights(const MFFloat&);
  bool             	assign_orientation(const SFRotation&);
  bool             	assign_angle(const SFFloat&);
  
  // eventOuts:
  //  SFBool            	isBound;
  void             	post_isBound(const SFBool& val);
  
  // update status
  inline bool      	isBound_is_updated(void) { return (status & isBound_updated); }
  inline void      	isBound_clear_update(void) { status &= ~isBound_updated; }
  inline bool      	spectralBasis_is_updated(void) { return (status & spectralBasis_updated); }
  inline void      	spectralBasis_clear_update(void) { status &= ~spectralBasis_updated; }
  inline bool      	spectralWeights_is_updated(void) { return (status & spectralWeights_updated); }
  inline void      	spectralWeights_clear_update(void) { status &= ~spectralWeights_updated; }
  inline bool      	orientation_is_updated(void) { return (status & orientation_updated); }
  inline void      	orientation_clear_update(void) { status &= ~orientation_updated; }
  inline bool      	angle_is_updated(void) { return (status & angle_updated); }
  inline void      	angle_clear_update(void) { status &= ~angle_updated; }
  
  // utility members
  Spectrum eval(const Vec3& position, const Vec3& direction, const Spectrum& specWeight, float *pdf);
  Vec3 sample(const Spectrum& specWeight, const Vec3& position, const float xi1, const float xi2,
	      Spectrum *value, float *pdf);
  Spectrum power(const Vec3& position);  

protected:
  inline void util_init(void) { }
  inline void util_clone(const PhBBackgroundLight& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_PhBBackgroundLight_H_*/
