// PhBBackgroundProjection.H: PhBBackgroundProjection nodes.

// This file has been generated using nodegen 0.51.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _PhBBackgroundProjection_H_
#define _PhBBackgroundProjection_H_

#include "xrml.H"

// utility includes
#include "vector.H"
// end of utility includes

namespace xrml {
#define PhBBackgroundProjectionTypeId 	"PhBBackgroundProjection"
extern bool IsPhBBackgroundProjection(SFNode*);

class PhBBackgroundProjection: public virtual SFNode {
public:
  //
  virtual int major_version(void), minor_version(void);
  virtual bool is_leaf_class(void);
  
  PhBBackgroundProjection();
  
  //
  virtual void     	render(void);
  
  // utility members
  virtual Vec3 direction2surface(const Vec3& direction);
  virtual Vec3 surface2direction(const Vec3& surfaceCoord);

  // given row y and column y, return (a, b, 0) 
  // with (a, y, 0) = starting position for column y
  // with (x, b, 0) = starting position for row x
  virtual Vec3 start(const Vec3& surfaceCoord);

  // given row y and column y, return (a, b, 0)
  // with a is length of column y
  // with b is length of row x
  virtual Vec3  size(const Vec3& surfaceCoord);

  // given 4 corners in surfacecoord., return the area of this
  // 'pixel' projected on the environment sphere.
  // sum of all area forming a sphere = 2*PI*PI
  virtual float area(const Vec3& upleft,
		     const Vec3& upright,
		     const Vec3& downleft,
		     const Vec3& downright);

  // gives the jacobian 
  // input surface coord
  virtual float jacobian(const Vec3 &surfaceCoord);
  
protected:
  inline void util_init(void) { }
  inline void util_clone(const PhBBackgroundProjection& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_PhBBackgroundProjection_H_*/
