// PhBBilinearInterpolation.H: PhBBilinearInterpolation nodes.

// This file has been generated using nodegen 0.53.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _PhBBilinearInterpolation_H_
#define _PhBBilinearInterpolation_H_

#include "xrml.H"
#include "PhBTexture.H"
#include "PhBImageTextureBase.H"

// utility includes
// end of utility includes

namespace xrml {
#define PhBBilinearInterpolationTypeId 	"PhBBilinearInterpolation"
extern bool IsPhBBilinearInterpolation(SFNode*);

class PhBBilinearInterpolation: public virtual SFNode, public PhBTexture {
private:
  //
  void clone_here(const PhBBilinearInterpolation&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    texture_updated = 0x1 
  };
  
protected:
  // raw children nodes (can be PROTO) + synchronize methods:
  SFNode* 	_texture;
  void 	synchronize_texture(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  PhBBilinearInterpolation();
  PhBBilinearInterpolation(const PhBBilinearInterpolation&);
  PhBBilinearInterpolation& operator=(const PhBBilinearInterpolation&);
  virtual ~PhBBilinearInterpolation();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  PhBImageTextureBase* 	texture;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_texture(SFNode*);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_texture(SFNode*);
  
  // update status
  inline bool      	texture_is_updated(void) { return (status & texture_updated); }
  inline void      	texture_clear_update(void) { status &= ~texture_updated; }
  
  // utility members

  virtual float *values(double u, double v, int *nrChannels=NULL);
  virtual long width(void) { return(texture->width()); }
  virtual long height(void) { return(texture->height()); }
  virtual long nrChannels(void) { return(texture->nrChannels()); }
  virtual void Dvalues(double u, double v, float *dX, float *dY, float *dZ) { texture->Dvalues(u, v, dX, dY, dZ); }

  virtual float *filteredValues(const Vec2& uv, const Vec2& da, 
				const Vec2& db, int *nrchannels=NULL);

protected:
  float *value;
  float *filteredValue;

  inline void util_init(void) { value = NULL; filteredValue = NULL; }
  inline void util_clone(const PhBBilinearInterpolation& src) { util_init(); }
  inline void util_destruct(void) 
  { 
    if(value) delete[] value; 
    if(filteredValue) delete[] filteredValue; 
  }  

  virtual float *boxFilteredValues(const Vec2& uv, const Vec2& da, 
				   const Vec2& db, int *nrchannels=NULL);
  virtual float *gaussianFilteredValues(const Vec2& uv, const Vec2& da, 
					const Vec2& db, int *nrchannels=NULL);
};

// end of utility members
} // namespace xrml
#endif /*_PhBBilinearInterpolation_H_*/
