/* PhBBlackBodySpectrum.C: PhBBlackBodySpectrum nodes (public source) */

#include "PhBBlackBodySpectrum.H"
#include <math.h>

namespace xrml {

#define c  3.0 * pow(10, 8)
#define k  1.38 * pow(10, -23)
#define h  6.626 * pow(10, -34)


float static Intensity(float wavelength, float T)
{
  // Plancks formula:
  //
  //            2pi * h * c^2
  // I(w) = ---------------------
  //        w^5 * (exp(hc/wkT)-1)
  wavelength =  wavelength * pow(10, -9);    // nano-meter -> meter
  float w5 = pow(wavelength, 5);
  float a = 2. * M_PI * h * c*c;  
  float b = (h * c) / (wavelength * k * T);
  
  return (a / (w5 * (exp(b) - 1)));
}

void PhBBlackBodySpectrum::render(void)
{
  Spectrum sum = Spectrum(0.);

  for(int x=0; x < 80; x++)
    {
      float wavelength = 380 + (x * 5);
      float I = Intensity(wavelength, temperature);

      sum += wavelength2xyz(wavelength, I);
    }

  value = sum * luminance / 80;
}

}  // namespace xrml
