/* PhBBrushMap.C: PhBBrushMap nodes (public source) */

#include "PhBBrushMap.H"

namespace xrml {

void PhBBrushMap::render(void)
{
  if(texture) texture->render();
  if(transform) transform->render();
}

Mat3 PhBBrushMap::distort(const Vec3 point)
{
  int nrChannels = 0;
  Vec3 X, Y, Z;

  // get texture value
  Vec3 texco = point;
  if (transform) texco *= transform->xf;
  float *value = (texture) ? texture->values(texco.x, texco.y, &nrChannels) : NULL;

  // need atleast 3 channels (ignore first 2 channels, 3rd = rotation around Z)
  if (nrChannels < 3) return Mat3();

  // dertemine X, Y, Z axis
  float a = value[2] * 2 * M_PI;

  Z = Vec3(0, 0, 1);
  X = Vec3(cos(a), -sin(a), 0);
  Y = Vec3(sin(a),  cos(a), 0);

  return Mat3( X, Y, Z);
}

}  // namespace xrml
