// PhBBumpMap.H: PhBBumpMap nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _PhBBumpMap_H_
#define _PhBBumpMap_H_

#include "xrml.H"
#include "PhBSurfaceDistortion.H"
#include "PhBTexture.H"
#include "Transform.H"

// utility includes
// end of utility includes

namespace xrml {
#define PhBBumpMapTypeId 	"PhBBumpMap"
extern bool IsPhBBumpMap(SFNode*);

class PhBBumpMap: public virtual SFNode, public PhBSurfaceDistortion {
private:
  //
  void clone_here(const PhBBumpMap&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    texture_updated = 0x1,
    transform_updated = 0x2,
    height_updated = 0x4 
  };
  
public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  PhBBumpMap();
  PhBBumpMap(const PhBBumpMap&);
  PhBBumpMap& operator=(const PhBBumpMap&);
  virtual ~PhBBumpMap();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  //  PhBTexture*      	texture;
  //  Transform*       	transform;
  SFFloat          	height;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_texture(SFNode*);
  void             	set_transform(SFNode*);
  void             	set_height(const SFFloat&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_texture(SFNode*);
  bool             	assign_transform(SFNode*);
  bool             	assign_height(const SFFloat&);
  
  // update status
  inline bool      	texture_is_updated(void) { return (status & texture_updated); }
  inline void      	texture_clear_update(void) { status &= ~texture_updated; }
  inline bool      	transform_is_updated(void) { return (status & transform_updated); }
  inline void      	transform_clear_update(void) { status &= ~transform_updated; }
  inline bool      	height_is_updated(void) { return (status & height_updated); }
  inline void      	height_clear_update(void) { status &= ~height_updated; }
  
  // utility members
  Mat3 distort(const Vec3 point);
  
protected:
  float *dX;
  float *dY;
  float *dZ;

  inline void util_init(void) { dX = NULL; dY = NULL; dZ = NULL; }
  inline void util_clone(const PhBBumpMap& src) { dX = NULL; dY = NULL; dZ = NULL; }
  inline void util_destruct(void) { delete[] dX;
                                    delete[] dY;
                                    delete[] dZ; }
};

// end of utility members
} // namespace xrml
#endif /*_PhBBumpMap_H_*/
