/* PhBDiffuseEmitter.C: PhBDiffuseEmitter nodes (public source) */

#include "PhBDiffuseEmitter.H"

namespace xrml {

void PhBDiffuseEmitter::render(void)
{
  //
}


float PhBDiffuseEmitter::emittance(int range)
{
  return (range & GR_DIFFUSE) ? 1. : 0.;
}

// pdf is proportional cosine angle w.r.t. Z axis.
Vec3 PhBDiffuseEmitter::sample(float xi1, float xi2, int range)
{
  double phi = 2. * M_PI * xi1;
  double cos_phi = cos(phi);
  double sin_phi = sin(phi);
  double cos_theta = sqrt(1.0-xi2);
  double sin_theta = sqrt(xi2);

  return Vec3(cos_phi * sin_theta,
	      sin_phi * sin_theta,
	      cos_theta);
}



float PhBDiffuseEmitter::eval(const Vec3& direction,
			       int range,
			       float *pdf)
{
  if (range & GR_DIFFUSE && direction.z > 0.) {
    if (pdf) *pdf = direction.z / M_PI;
    return 1. / M_PI;
  } else {
    if (pdf) *pdf = 0.;
    return 0.;
  }
}

}  // namespace xrml
