/* PhBEDF.C: PhBEDF nodes (public source) */

#include "PhBEDF.H"
#include "PhBLxySpectrum.H"
#include "PhBDiffuseEmitter.H"

namespace xrml {

void PhBEDF::render(void)
{
  static PhBSpectrum *unitNeutralSpectrum = new PhBLxySpectrum;
  static PhBEmitter *diffuseEmitter = new PhBDiffuseEmitter;

  if (!spectrum) spectrum = unitNeutralSpectrum;
  spectrum->render();

  if (!emitter) emitter = diffuseEmitter;
  emitter->render();
}

Spectrum PhBEDF::eval(const Vec3& direction,
	      int range,
	      float *pdf)
{
  return spectrum->value * intensity * emitter->eval(direction, range, pdf);
}

Vec3 PhBEDF::sample(float xi1, float xi2,
	    int range)
{
  return emitter->sample(xi1, xi2, range);
}

Spectrum PhBEDF::emittance(int range)
{
  return spectrum->value * intensity * emitter->emittance(range);
}


}  // namespace xrml
