// PhBEDF.H: PhBEDF nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _PhBEDF_H_
#define _PhBEDF_H_

#include "xrml.H"
#include "PhBSpectrum.H"
#include "PhBEmitter.H"

// utility includes
// end of utility includes

namespace xrml {
#define PhBEDFTypeId 	"PhBEDF"
extern bool IsPhBEDF(SFNode*);

class PhBEDF: public virtual SFNode {
private:
  //
  void clone_here(const PhBEDF&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    intensity_updated = 0x1,
    spectrum_updated = 0x2,
    emitter_updated = 0x4 
  };
  
protected:
  // raw children nodes (can be PROTO) + synchronize methods:
  SFNode* 	_spectrum;
  void 	synchronize_spectrum(void);
  SFNode* 	_emitter;
  void 	synchronize_emitter(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  PhBEDF();
  PhBEDF(const PhBEDF&);
  PhBEDF& operator=(const PhBEDF&);
  virtual ~PhBEDF();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  SFFloat          	intensity;
  PhBSpectrum*     	spectrum;
  PhBEmitter*      	emitter;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_intensity(const SFFloat&);
  void             	set_spectrum(SFNode*);
  void             	set_emitter(SFNode*);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_intensity(const SFFloat&);
  bool             	assign_spectrum(SFNode*);
  bool             	assign_emitter(SFNode*);
  
  // update status
  inline bool      	intensity_is_updated(void) { return (status & intensity_updated); }
  inline void      	intensity_clear_update(void) { status &= ~intensity_updated; }
  inline bool      	spectrum_is_updated(void) { return (status & spectrum_updated); }
  inline void      	spectrum_clear_update(void) { status &= ~spectrum_updated; }
  inline bool      	emitter_is_updated(void) { return (status & emitter_updated); }
  inline void      	emitter_clear_update(void) { status &= ~emitter_updated; }
  
  // utility members
  // to be called after render(): render() fills in default values for
  // spectrum and emitter.
  Spectrum eval(const Vec3& direction,
		int range,
		float *pdf);

  Vec3 sample(float xi1, float xi2,
	      int range);
  
  Spectrum emittance(int range);


protected:
  inline void util_init(void) { }
  inline void util_clone(const PhBEDF& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_PhBEDF_H_*/
