// PhBHeterogeneousSurface.H: PhBHeterogeneousSurface nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _PhBHeterogeneousSurface_H_
#define _PhBHeterogeneousSurface_H_

#include "xrml.H"
#include "PhBSurface.H"
#include "PhBSDF.H"

// utility includes
// end of utility includes

namespace xrml {
#define PhBHeterogeneousSurfaceTypeId 	"PhBHeterogeneousSurface"
extern bool IsPhBHeterogeneousSurface(SFNode*);

class PhBHeterogeneousSurface: public virtual SFNode, public PhBSurface {
private:
  //
  void clone_here(const PhBHeterogeneousSurface&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    bsdf_updated = 0x1 
  };
  
protected:
  // raw children nodes (can be PROTO) + synchronize methods:
  MFNode 	_bsdf;
  void 	synchronize_bsdf(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  PhBHeterogeneousSurface();
  PhBHeterogeneousSurface(const PhBHeterogeneousSurface&);
  PhBHeterogeneousSurface& operator=(const PhBHeterogeneousSurface&);
  virtual ~PhBHeterogeneousSurface();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  array<PhBSDF*> 	bsdf;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_bsdf(const MFNode&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_bsdf(const MFNode&);
  
  // update status
  inline bool      	bsdf_is_updated(void) { return (status & bsdf_updated); }
  inline void      	bsdf_clear_update(void) { status &= ~bsdf_updated; }
  
  // utility members
  bool isLightSource(void);

  bool isScatterer(void);

  bool isTextured(void)
  {
    return false;
  }

  Spectrum evaluateEDF(const Vec3& point, const Vec3& texco, const Vec3& texco3d,
		       const Vec3& direction,
		       const Spectrum& specWeight,
		       int range,
		       float *pdf);

  Vec3 sampleEDF(const Vec3& point, const Vec3& texco, const Vec3& texco3d,
		 const Spectrum& specWeight,
		 float xi1, float xi2,
		 int range,
		 Spectrum *value, float *pdf);

  Spectrum emittance(const Vec3& point, const Vec3& texco, const Vec3& texco3d, int range);

  Spectrum evaluateBSDF(const Vec3& point, const Vec3& texco, const Vec3& texco3d,
			const Vec3& inDir,
			const Vec3& outDir,
			const Spectrum& inSpec,
			const complex& indexIn,
			const complex& indexOut,
			int modes, 
			float *pdf);

  Vec3 sampleBSDF(const Vec3& point, const Vec3& texco, const Vec3& texco3d,
		  const Vec3& inDir,
		  const Spectrum& inSpec,
		  const complex& indexIn,
		  const complex& indexOut,
		  float xi1, float xi2, 
		  int modes,
		  Spectrum *value, float *pdf);

  Spectrum albedo(const Vec3& point, const Vec3& texco, const Vec3& texco3d,
		  const Vec3& inDir,
		  const complex& indexIn,
		  const complex& indexOut,
		  int modes);

protected:
  // bsdf component sampling weights.
  array<float> w;
  // trans[i] = fraction of incident power not scattered in layers 0 .. i-1.
  array<Spectrum> trans;

  // Calculates accumulated layer transmittances. If pdf is not a null pointer,
  // also computes layer sampling weights.
  // Returns sum of computed sampling weights if pdf is not null.
  // Transmittances and weights are filled in the arrays declared here before.
  float calculate_transmittances(const Vec3& inDir, 
				const complex& indexIn, 
				const complex& indexOut,
				const Spectrum& inSpec,
				const int modes,
				float *pdf);
  
  inline void util_init(void) { }
  inline void util_clone(const PhBHeterogeneousSurface& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_PhBHeterogeneousSurface_H_*/
