// PhBHomogeneousMedium.H: PhBHomogeneousMedium nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _PhBHomogeneousMedium_H_
#define _PhBHomogeneousMedium_H_

#include "xrml.H"
#include "PhBMedium.H"
#include "PhBPhF.H"
#include "PhBSpectrum.H"

// utility includes
// end of utility includes

namespace xrml {
#define PhBHomogeneousMediumTypeId 	"PhBHomogeneousMedium"
extern bool IsPhBHomogeneousMedium(SFNode*);

class PhBHomogeneousMedium: public virtual SFNode, public PhBMedium {
private:
  //
  void clone_here(const PhBHomogeneousMedium&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    indexOfRefraction_updated = 0x1,
    scatteringCrossSection_updated = 0x2,
    absorptionCrossSection_updated = 0x4,
    phaseFunction_updated = 0x8,
    selfEmittedFluxDensity_updated = 0x10 
  };
  
protected:
  // raw children nodes (can be PROTO) + synchronize methods:
  MFNode 	_phaseFunction;
  void 	synchronize_phaseFunction(void);
  SFNode* 	_selfEmittedFluxDensity;
  void 	synchronize_selfEmittedFluxDensity(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  PhBHomogeneousMedium();
  PhBHomogeneousMedium(const PhBHomogeneousMedium&);
  PhBHomogeneousMedium& operator=(const PhBHomogeneousMedium&);
  virtual ~PhBHomogeneousMedium();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  SFVec2f          	indexOfRefraction;
  SFFloat          	scatteringCrossSection;
  SFFloat          	absorptionCrossSection;
  array<PhBPhF*> 	phaseFunction;
  PhBSpectrum*     	selfEmittedFluxDensity;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_indexOfRefraction(const SFVec2f&);
  void             	set_scatteringCrossSection(const SFFloat&);
  void             	set_absorptionCrossSection(const SFFloat&);
  void             	set_phaseFunction(const MFNode&);
  void             	set_selfEmittedFluxDensity(SFNode*);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_indexOfRefraction(const SFVec2f&);
  bool             	assign_scatteringCrossSection(const SFFloat&);
  bool             	assign_absorptionCrossSection(const SFFloat&);
  bool             	assign_phaseFunction(const MFNode&);
  bool             	assign_selfEmittedFluxDensity(SFNode*);
  
  // update status
  inline bool      	indexOfRefraction_is_updated(void) { return (status & indexOfRefraction_updated); }
  inline void      	indexOfRefraction_clear_update(void) { status &= ~indexOfRefraction_updated; }
  inline bool      	scatteringCrossSection_is_updated(void) { return (status & scatteringCrossSection_updated); }
  inline void      	scatteringCrossSection_clear_update(void) { status &= ~scatteringCrossSection_updated; }
  inline bool      	absorptionCrossSection_is_updated(void) { return (status & absorptionCrossSection_updated); }
  inline void      	absorptionCrossSection_clear_update(void) { status &= ~absorptionCrossSection_updated; }
  inline bool      	phaseFunction_is_updated(void) { return (status & phaseFunction_updated); }
  inline void      	phaseFunction_clear_update(void) { status &= ~phaseFunction_updated; }
  inline bool      	selfEmittedFluxDensity_is_updated(void) { return (status & selfEmittedFluxDensity_updated); }
  inline void      	selfEmittedFluxDensity_clear_update(void) { status &= ~selfEmittedFluxDensity_updated; }
  
  // utility members
  complex get_indexOfRefraction(void);

  
  Spectrum evaluateEDF(const Vec3& point,
		       const Vec3& texco, const Vec3& texco3d,
		       const Vec3& direction,
		       const Spectrum& specWeight,
		       int range,
		       float *pdf);

  Vec3 sampleEDF(const Vec3& point,
		 const Vec3& texco, const Vec3& texco3d,
		 const Spectrum& specWeight,
		 float xi1, float xi2,
		 int range,
		 Spectrum *value, float *pdf);

  Spectrum emittance(const Vec3& point,
		     const Vec3& texco, const Vec3& texco3d,
		     int range);

  Spectrum evaluateBSDF(const Vec3& point,
			const Vec3& texco, const Vec3& texco3d,
			const Vec3& inDir,
			const Vec3& outDir,
			const Spectrum& inSpec,
			const complex& indexIn,
			const complex& indexOut,
			int modes, 
			float *pdf);

  Vec3 sampleBSDF(const Vec3& point, const Vec3& texco, const Vec3& texco3d,
		  const Vec3& inDir,
		  const Spectrum& inSpec,
		  const complex& indexIn,
		  const complex& indexOut,
		  float xi1, float xi2, 
		  int modes,
		  Spectrum *value, float *pdf);

  Spectrum albedo(const Vec3& point,
		  const Vec3& texco, const Vec3& texco3d,
		  const Vec3& inDir,
		  const complex& indexIn,
		  const complex& indexOut,
		  int modes);


protected:
  inline void util_init(void) { }
  inline void util_clone(const PhBHomogeneousMedium& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_PhBHomogeneousMedium_H_*/
