// PhBHomogeneousSurface.H: PhBHomogeneousSurface nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _PhBHomogeneousSurface_H_
#define _PhBHomogeneousSurface_H_

#include "xrml.H"
#include "PhBSurface.H"
#include "PhBEDF.H"
#include "PhBSDF.H"

// utility includes
// end of utility includes

namespace xrml {
#define PhBHomogeneousSurfaceTypeId 	"PhBHomogeneousSurface"
extern bool IsPhBHomogeneousSurface(SFNode*);

class PhBHomogeneousSurface: public virtual SFNode, public PhBSurface {
private:
  //
  void clone_here(const PhBHomogeneousSurface&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    edf_updated = 0x1,
    bsdf_updated = 0x2 
  };
  
protected:
  // raw children nodes (can be PROTO) + synchronize methods:
  MFNode 	_edf;
  void 	synchronize_edf(void);
  MFNode 	_bsdf;
  void 	synchronize_bsdf(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  PhBHomogeneousSurface();
  PhBHomogeneousSurface(const PhBHomogeneousSurface&);
  PhBHomogeneousSurface& operator=(const PhBHomogeneousSurface&);
  virtual ~PhBHomogeneousSurface();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  array<PhBEDF*> 	edf;
  array<PhBSDF*> 	bsdf;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_edf(const MFNode&);
  void             	set_bsdf(const MFNode&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_edf(const MFNode&);
  bool             	assign_bsdf(const MFNode&);
  
  // update status
  inline bool      	edf_is_updated(void) { return (status & edf_updated); }
  inline void      	edf_clear_update(void) { status &= ~edf_updated; }
  inline bool      	bsdf_is_updated(void) { return (status & bsdf_updated); }
  inline void      	bsdf_clear_update(void) { status &= ~bsdf_updated; }
  
  // utility members
  bool isLightSource(void);

  bool isScatterer(void);

  bool isTextured(void)
  {
    return false;
  }

  Spectrum evaluateEDF(const Vec3& point, const Vec3& texco, const Vec3& texco3d,
		       const Vec3& direction,
		       const Spectrum& specWeight,
		       int range,
		       float *pdf);

  Vec3 sampleEDF(const Vec3& point, const Vec3& texco, const Vec3& texco3d,
		 const Spectrum& specWeight,
		 float xi1, float xi2,
		 int range,
		 Spectrum *value, float *pdf);

  Spectrum emittance(const Vec3& point,  const Vec3& texco, const Vec3& texco3d,int range);

  Spectrum evaluateBSDF(const Vec3& point, const Vec3& texco, const Vec3& texco3d,
			const Vec3& inDir,
			const Vec3& outDir,
			const Spectrum& inSpec,
			const complex& indexIn,
			const complex& indexOut,
			int modes, 
			float *pdf);

  Vec3 sampleBSDF(const Vec3& point, const Vec3& texco, const Vec3& texco3d,
		  const Vec3& inDir,
		  const Spectrum& inSpec,
		  const complex& indexIn,
		  const complex& indexOut,
		  float xi1, float xi2, 
		  int modes,
		  Spectrum *value, float *pdf);

  Spectrum albedo(const Vec3& point, const Vec3& texco, const Vec3& texco3d,
		  const Vec3& inDir,
		  const complex& indexIn,
		  const complex& indexOut,
		  int modes);


protected:
  // edf or bsdf component sampling weights.
  array<float> w;

  inline void util_init(void) { }
  inline void util_clone(const PhBHomogeneousSurface& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_PhBHomogeneousSurface_H_*/
