// PhBLafortuneReflector.H: PhBLafortuneReflector nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _PhBLafortuneReflector_H_
#define _PhBLafortuneReflector_H_

#include "xrml.H"
#include "PhBScatterer.H"

// utility includes
// end of utility includes

namespace xrml {
#define PhBLafortuneReflectorTypeId 	"PhBLafortuneReflector"
extern bool IsPhBLafortuneReflector(SFNode*);

class PhBLafortuneReflector: public virtual SFNode, public PhBScatterer {
private:
  //
  void clone_here(const PhBLafortuneReflector&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    C_updated = 0x1,
    n_updated = 0x2 
  };
  
public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  PhBLafortuneReflector();
  PhBLafortuneReflector(const PhBLafortuneReflector&);
  PhBLafortuneReflector& operator=(const PhBLafortuneReflector&);
  virtual ~PhBLafortuneReflector();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  SFVec3f          	C;
  SFFloat          	n;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_C(const SFVec3f&);
  void             	set_n(const SFFloat&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_C(const SFVec3f&);
  bool             	assign_n(const SFFloat&);
  
  // update status
  inline bool      	C_is_updated(void) { return (status & C_updated); }
  inline void      	C_clear_update(void) { status &= ~C_updated; }
  inline bool      	n_is_updated(void) { return (status & n_updated); }
  inline void      	n_clear_update(void) { status &= ~n_updated; }
  
  // utility members
  static float glossy_threshold;

  float albedo(const Vec3& inDir,
	       const complex& IndexIn,
	       const complex& IndexOut,
	       int modes);
  Vec3 sample(const Vec3& inDir,
	      const complex& IndexIn,
	      const complex& IndexOut,
	      float xi1, float xi2,
	      int modes);
  float eval(const Vec3& inDir,
	     const Vec3& outDir,
	     const complex& IndexIn,
	     const complex& IndexOut,
	     int modes, 
	     float *pdf);

protected:
  Vec3 MirrorDirection(const Vec3& inDir);

  inline void util_init(void) { }
  inline void util_clone(const PhBLafortuneReflector& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_PhBLafortuneReflector_H_*/
