// PhBMixedSpectrum.H: PhBMixedSpectrum nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _PhBMixedSpectrum_H_
#define _PhBMixedSpectrum_H_

#include "xrml.H"
#include "PhBSpectrum.H"

// utility includes
// end of utility includes

namespace xrml {
#define PhBMixedSpectrumTypeId 	"PhBMixedSpectrum"
extern bool IsPhBMixedSpectrum(SFNode*);

class PhBMixedSpectrum: public virtual SFNode, public PhBSpectrum {
private:
  //
  void clone_here(const PhBMixedSpectrum&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    spectra_updated = 0x1,
    weight_updated = 0x2 
  };
  
protected:
  // raw children nodes (can be PROTO) + synchronize methods:
  MFNode 	_spectra;
  void 	synchronize_spectra(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  PhBMixedSpectrum();
  PhBMixedSpectrum(const PhBMixedSpectrum&);
  PhBMixedSpectrum& operator=(const PhBMixedSpectrum&);
  virtual ~PhBMixedSpectrum();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  array<PhBSpectrum*> 	spectra;
  MFFloat          	weight;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_spectra(const MFNode&);
  void             	set_weight(const MFFloat&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_spectra(const MFNode&);
  bool             	assign_weight(const MFFloat&);
  
  // update status
  inline bool      	spectra_is_updated(void) { return (status & spectra_updated); }
  inline void      	spectra_clear_update(void) { status &= ~spectra_updated; }
  inline bool      	weight_is_updated(void) { return (status & weight_updated); }
  inline void      	weight_clear_update(void) { status &= ~weight_updated; }
  
  // utility members
  
protected:
  inline void util_init(void) { }
  inline void util_clone(const PhBMixedSpectrum& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_PhBMixedSpectrum_H_*/
