// PhBMonitorCalibration.H: PhBMonitorCalibration nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _PhBMonitorCalibration_H_
#define _PhBMonitorCalibration_H_

#include "xrml.H"
#include "Bindable.H"
#include "Children.H"
#include "PhBSpectrum.H"

// utility includes
#include "matrix.H"
// end of utility includes

namespace xrml {
#define PhBMonitorCalibrationTypeId 	"PhBMonitorCalibration"
extern bool IsPhBMonitorCalibration(SFNode*);

class PhBMonitorCalibration: public virtual SFNode, public Bindable, public Children {
private:
  //
  void clone_here(const PhBMonitorCalibration&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    isBound_updated = 0x1,
    red_updated = 0x2,
    green_updated = 0x4,
    blue_updated = 0x8,
    white_updated = 0x10,
    gamma_updated = 0x20,
    maxLuminance_updated = 0x40,
    maxContrast_updated = 0x80 
  };
  
protected:
  // raw children nodes (can be PROTO) + synchronize methods:
  SFNode* 	_red;
  void 	synchronize_red(void);
  SFNode* 	_green;
  void 	synchronize_green(void);
  SFNode* 	_blue;
  void 	synchronize_blue(void);
  SFNode* 	_white;
  void 	synchronize_white(void);

  // raw eventOut posting:
  void post_isBound(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  PhBMonitorCalibration();
  PhBMonitorCalibration(const PhBMonitorCalibration&);
  PhBMonitorCalibration& operator=(const PhBMonitorCalibration&);
  virtual ~PhBMonitorCalibration();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  PhBSpectrum*     	red;
  PhBSpectrum*     	green;
  PhBSpectrum*     	blue;
  PhBSpectrum*     	white;
  SFColor          	gamma;
  SFFloat          	maxLuminance;
  SFFloat          	maxContrast;
  
  // eventIns:
  void             	set_bind(const SFBool&);
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_red(SFNode*);
  void             	set_green(SFNode*);
  void             	set_blue(SFNode*);
  void             	set_white(SFNode*);
  void             	set_gamma(const SFColor&);
  void             	set_maxLuminance(const SFFloat&);
  void             	set_maxContrast(const SFFloat&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_red(SFNode*);
  bool             	assign_green(SFNode*);
  bool             	assign_blue(SFNode*);
  bool             	assign_white(SFNode*);
  bool             	assign_gamma(const SFColor&);
  bool             	assign_maxLuminance(const SFFloat&);
  bool             	assign_maxContrast(const SFFloat&);
  
  // eventOuts:
  //  SFBool            	isBound;
  void             	post_isBound(const SFBool& val);
  
  // update status
  inline bool      	isBound_is_updated(void) { return (status & isBound_updated); }
  inline void      	isBound_clear_update(void) { status &= ~isBound_updated; }
  inline bool      	red_is_updated(void) { return (status & red_updated); }
  inline void      	red_clear_update(void) { status &= ~red_updated; }
  inline bool      	green_is_updated(void) { return (status & green_updated); }
  inline void      	green_clear_update(void) { status &= ~green_updated; }
  inline bool      	blue_is_updated(void) { return (status & blue_updated); }
  inline void      	blue_clear_update(void) { status &= ~blue_updated; }
  inline bool      	white_is_updated(void) { return (status & white_updated); }
  inline void      	white_clear_update(void) { status &= ~white_updated; }
  inline bool      	gamma_is_updated(void) { return (status & gamma_updated); }
  inline void      	gamma_clear_update(void) { status &= ~gamma_updated; }
  inline bool      	maxLuminance_is_updated(void) { return (status & maxLuminance_updated); }
  inline void      	maxLuminance_clear_update(void) { status &= ~maxLuminance_updated; }
  inline bool      	maxContrast_is_updated(void) { return (status & maxContrast_updated); }
  inline void      	maxContrast_clear_update(void) { status &= ~maxContrast_updated; }
  
  // utility members
  // converts an SFColor RGB color to a Spectrum
  Spectrum RGBToSpectrum(const SFColor& rgb);

protected:
  // color transformation matrices, computed by render()
  Mat3 xyz2rgb, rgb2xyz;
  
  inline void util_init(void) { }
  inline void util_clone(const PhBMonitorCalibration& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_PhBMonitorCalibration_H_*/
