/* PhBNoiseTexture.C: PhBNoiseTexture nodes (public source) */

#include "PhBNoiseTexture.H"
#include "PerlinNoise.H"
#include <math.h>

namespace xrml {

void PhBNoiseTexture::render(void)
{
  if (noiseInit == false) {
    noise = PerlinNoise(2);
    noiseInit = true;
  }
}

float *PhBNoiseTexture::values(double u, double v, int *nrChannels)
{
  float coord[2];
  if (nrChannels) *nrChannels = 2;

  // apply scaling
  coord[0] = (u * k) - floor(u * k);
  coord[1] = (v * k) - floor(v * k);
  
  // generate noise
  value[0] = ((noise.noise(coord) + 1) / 2);
  value[1] = 1. - value[0];

  return value;
}

void PhBNoiseTexture::Dvalues(double u, double v,
				 float *dX,
				 float *dY,
				 float *dZ)
{
  float d[2], coord[2];

  // make coord-array
  coord[0] = (u * k) - floor(u * k);
  coord[1] = (v * k) - floor(u * k);
  
  // get Dnoise
  noise.Dnoise(coord, d, k / noise.getCtrlPoints());

  // calc dX, dY, dZ
  dX[0] = d[0];      dX[1] = -d[0];
  dY[0] = d[1];      dY[1] = -d[1];
  dZ[0] = 0;         dZ[1] = 0;
}

}  // namespace xrml
