/* PhBPerfectSpecularReflector.C: PhBPerfectSpecularReflector nodes (public source) */

#include "PhBPerfectSpecularReflector.H"

namespace xrml {

void PhBPerfectSpecularReflector::render(void)
{
  //
}

float PhBPerfectSpecularReflector::albedo(const Vec3& inDir,
				  const complex& IndexIn,
				  const complex& IndexOut,
				  int modes)
{
  return (modes & SM_SPECULAR_REFLECTION)
    ? 1.
    : 0.;
}

static Vec3 IdealReflectedDirection(const Vec3& inDir)
{
  return Vec3(-inDir.x, -inDir.y, inDir.z);
}

Vec3 PhBPerfectSpecularReflector::sample(const Vec3& inDir,
				 const complex& IndexIn,
				 const complex& IndexOut,
				 float xi1, float xi2,
				 int modes)
{
  return IdealReflectedDirection(inDir);
}

float PhBPerfectSpecularReflector::eval(const Vec3& inDir,
				const Vec3& outDir,
				const complex& IndexIn,
				const complex& IndexOut,
				int modes,
				float *pdf)
{
  if (pdf) *pdf = 0.;
  if (!(modes & SM_SPECULAR_REFLECTION))
    return 0.;

  if ((IdealReflectedDirection(inDir) - outDir) |= EPSILON) {
    // outDir is ideal reflected direction
    if (pdf) *pdf = 1e10;
    return 1e10 / fabs(outDir.z);
  } else
    return 0.;
}

}  // namespace xrml
