/* PhBPhF.C: PhBPhF nodes (public source) */

#include "PhBPhF.H"

namespace xrml {


void PhBPhF::render(void)
{
  if (phaseFunction) phaseFunction->render();
}

Spectrum PhBPhF::eval(const Vec3& inDir,
		      const Vec3& outDir,
		      const complex& indexIn,
		      const complex& indexOut,
		      int modes,
		      float *pdf)
{
  Spectrum value = spectrum->value;

  value = (intensity * phaseFunction->eval(inDir, outDir, modes, pdf) );

  return(value);
}

Vec3 PhBPhF::sample(const Vec3& inDir,
		    const complex& indexIn,
		    const complex& indexOut,
		    float xi1, float xi2,
		    int modes)
{
  return( phaseFunction->sample(inDir, xi1, xi2, modes) );
}
 
Spectrum PhBPhF::albedo(const Vec3& inDir,
			const complex& indexIn,
			const complex& indexOut,
			int modes)
{
  Spectrum albedo = spectrum->value;

  albedo *= (intensity * phaseFunction->albedo(inDir, modes));

  return(albedo);
}


}  // namespace xrml
