/* PhBSampledSpectrum.C: PhBSampledSpectrum nodes (public source) */

#include "PhBSampledSpectrum.H"

namespace xrml {

void PhBSampledSpectrum::render(void)
{
  float distance = (max - min) / samples.size;
  Spectrum sum = Spectrum(0.);
  int pos = 0;

  for(float w=min; w < max; w+=distance)
    {
      sum += wavelength2xyz(w, samples[pos++]);
    }

  value = sum * scale / samples.size;
}

}  // namespace xrml
