// PhBSchlickReflector.H: PhBSchlickReflector nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _PhBSchlickReflector_H_
#define _PhBSchlickReflector_H_

#include "xrml.H"
#include "PhBScatterer.H"

// utility includes
// end of utility includes

namespace xrml {
#define PhBSchlickReflectorTypeId 	"PhBSchlickReflector"
extern bool IsPhBSchlickReflector(SFNode*);

class PhBSchlickReflector: public virtual SFNode, public PhBScatterer {
private:
  //
  void clone_here(const PhBSchlickReflector&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    roughness_updated = 0x1,
    isotropy_updated = 0x2,
    selfShadowing_updated = 0x4 
  };
  
public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  PhBSchlickReflector();
  PhBSchlickReflector(const PhBSchlickReflector&);
  PhBSchlickReflector& operator=(const PhBSchlickReflector&);
  virtual ~PhBSchlickReflector();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  SFFloat          	roughness;
  SFFloat          	isotropy;
  SFBool           	selfShadowing;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_roughness(const SFFloat&);
  void             	set_isotropy(const SFFloat&);
  void             	set_selfShadowing(const SFBool&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_roughness(const SFFloat&);
  bool             	assign_isotropy(const SFFloat&);
  bool             	assign_selfShadowing(const SFBool&);
  
  // update status
  inline bool      	roughness_is_updated(void) { return (status & roughness_updated); }
  inline void      	roughness_clear_update(void) { status &= ~roughness_updated; }
  inline bool      	isotropy_is_updated(void) { return (status & isotropy_updated); }
  inline void      	isotropy_clear_update(void) { status &= ~isotropy_updated; }
  inline bool      	selfShadowing_is_updated(void) { return (status & selfShadowing_updated); }
  inline void      	selfShadowing_clear_update(void) { status &= ~selfShadowing_updated; }
  
  // utility members
  float albedo(const Vec3& inDir,
	       const complex& IndexIn,
	       const complex& IndexOut,
	       int modes);
  Vec3 sample(const Vec3& inDir,
	      const complex& IndexIn,
	      const complex& IndexOut,
	      float xi1, float xi2,
	      int modes);
  float eval(const Vec3& inDir,
	     const Vec3& outDir,
	     const complex& IndexIn,
	     const complex& IndexOut,
	     int modes, 
	     float *pdf);

protected:
  inline void util_init(void) { }
  inline void util_clone(const PhBSchlickReflector& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_PhBSchlickReflector_H_*/
