/* PhBSimpleBSDF.C: PhBSimpleBSDF nodes (public source) */

#include "PhBSimpleBSDF.H"
#include "PhBLxySpectrum.H"
#include "PhBDiffuseReflector.H"

namespace xrml {

void PhBSimpleBSDF::render(void)
{
  static PhBSpectrum *unitNeutralSpectrum = new PhBLxySpectrum;
  static PhBScatterer *diffuseReflector = new PhBDiffuseReflector;

  if (!spectrum) spectrum = unitNeutralSpectrum;
  spectrum->render();

  if (!scatterer) scatterer = diffuseReflector;
  scatterer->render();
}

Spectrum PhBSimpleBSDF::eval(const Vec3& inDir,
			     const Vec3& outDir,
			     const complex& indexIn,
			     const complex& indexOut,
			     int modes,
			     float *pdf)
{
  return spectrum->value *
    (intensity * scatterer->eval(inDir, outDir, indexIn, indexOut, modes, pdf));
}

Vec3 PhBSimpleBSDF::sample(const Vec3& inDir,
			   const complex& indexIn,
			   const complex& indexOut,
			   float xi1, float xi2,
			   int modes)
{
  return scatterer->sample(inDir, indexIn, indexOut, xi1, xi2, modes);
}

Spectrum PhBSimpleBSDF::albedo(const Vec3& inDir,
			       const complex& indexIn,
			       const complex& indexOut,
			       int modes)
{
  return spectrum->value *
    (intensity * scatterer->albedo(inDir, indexIn, indexOut, modes));
}



}  // namespace xrml
