// PhBSimpleBSDF.H: PhBSimpleBSDF nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _PhBSimpleBSDF_H_
#define _PhBSimpleBSDF_H_

#include "xrml.H"
#include "PhBSDF.H"
#include "PhBSpectrum.H"
#include "PhBScatterer.H"

// utility includes
// end of utility includes

namespace xrml {
#define PhBSimpleBSDFTypeId 	"PhBSimpleBSDF"
extern bool IsPhBSimpleBSDF(SFNode*);

class PhBSimpleBSDF: public virtual SFNode, public PhBSDF {
private:
  //
  void clone_here(const PhBSimpleBSDF&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    intensity_updated = 0x1,
    spectrum_updated = 0x2,
    scatterer_updated = 0x4 
  };
  
protected:
  // raw children nodes (can be PROTO) + synchronize methods:
  SFNode* 	_spectrum;
  void 	synchronize_spectrum(void);
  SFNode* 	_scatterer;
  void 	synchronize_scatterer(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  PhBSimpleBSDF();
  PhBSimpleBSDF(const PhBSimpleBSDF&);
  PhBSimpleBSDF& operator=(const PhBSimpleBSDF&);
  virtual ~PhBSimpleBSDF();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  SFFloat          	intensity;
  PhBSpectrum*     	spectrum;
  PhBScatterer*    	scatterer;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_intensity(const SFFloat&);
  void             	set_spectrum(SFNode*);
  void             	set_scatterer(SFNode*);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_intensity(const SFFloat&);
  bool             	assign_spectrum(SFNode*);
  bool             	assign_scatterer(SFNode*);
  
  // update status
  inline bool      	intensity_is_updated(void) { return (status & intensity_updated); }
  inline void      	intensity_clear_update(void) { status &= ~intensity_updated; }
  inline bool      	spectrum_is_updated(void) { return (status & spectrum_updated); }
  inline void      	spectrum_clear_update(void) { status &= ~spectrum_updated; }
  inline bool      	scatterer_is_updated(void) { return (status & scatterer_updated); }
  inline void      	scatterer_clear_update(void) { status &= ~scatterer_updated; }
  
  // utility members
  Spectrum eval(const Vec3& inDir,
		const Vec3& outDir,
		const complex& indexIn,
		const complex& indexOut,
		int modes,
		float *pdf);

  Vec3 sample(const Vec3& inDir,
	      const complex& indexIn,
	      const complex& indexOut,
	      float xi1, float xi2,
	      int modes);

  Spectrum albedo(const Vec3& inDir,
		  const complex& indexIn,
		  const complex& indexOut,
		  int modes);

  
protected:
  inline void util_init(void) { }
  inline void util_clone(const PhBSimpleBSDF& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_PhBSimpleBSDF_H_*/
