/* PhBSpectrum.C: PhBSpectrum nodes (public source) */

#include "PhBSpectrum.H"

namespace xrml {

void PhBSpectrum::render(void)
{
  Warning(NULL, "PhBSpectrum::render(): not yet implemented");
}


float wavelength_table[80][4] = {
  {380, .0014, .0000, .0065},
  {385, .0022, .0001, .0105},
  {390, .0042, .0001, .0201},
  {395, .0076, .0002, .0362},
  {400, .0143, .0004, .0679},
  /*************************/
  {405, .0232, .0006, .1102},
  {410, .0435, .0012, .2074},
  {415, .0776, .0022, .3713},
  {420, .1344, .0040, .6456},
  {425, .2148, .0073,1.0391},
  /*************************/
  {430, .2839, .0116,1.3856},
  {435, .3285, .0168,1.6230},
  {440, .3483, .0230,1.7471},
  {445, .3481, .0298,1.7826},
  {450, .3362, .0380,1.7721},
  /*************************/
  {455, .3187, .0480,1.7441},
  {460, .2908, .0600,1.6692},
  {465, .2511, .0739,1.5281},
  {470, .1954, .0910,1.2876},
  {475, .1421, .1126,1.0419},
  /*************************/
  {480, .0956, .1390, .8130},
  {485, .0580, .1693, .6162},
  {490, .0320, .2080, .4652},
  {495, .0147, .2586, .3533},
  {500, .0049, .3230, .2720},
  /*************************/
  {505, .0024, .4073, .2123},
  {510, .0093, .5030, .1582},
  {515, .0291, .6082, .1117},
  {520, .0633, .7100, .0782},
  {525, .1096, .7932, .0573},
  /*************************/
  {530, .1655, .8620, .0422},
  {535, .2257, .9149, .0298},
  {540, .2904, .9540, .0203},
  {545, .3597, .9803, .0134},
  {550, .4334, .9950, .0087},
  /*************************/
  {555, .5121,1.0002, .0057},
  {560, .5945, .9950, .0039},
  {565, .6784, .9786, .0027},
  {570, .7621, .9520, .0021},
  {575, .8425, .9154, .0018},
  /*************************/
  {580, .9163, .8700, .0017},
  {585, .9786, .8163, .0014},
  {590,1.0263, .7570, .0011},
  {595,1.0567, .6949, .0010},
  {600,1.0622, .6310, .0008},
  /*************************/
  {605,1.0456, .5668, .0006},
  {610,1.0026, .5030, .0003},
  {615, .9384, .4412, .0002},
  {620, .8544, .3810, .0002},
  {625, .7514, .3210, .0001},
  /*************************/
  {630, .6424, .2650, .0000},
  {635, .5419, .2170, .0000},
  {640, .4479, .1750, .0000},
  {645, .3608, .1382, .0000},
  {650, .2835, .1070, .0000},
  /*************************/
  {655, .2187, .0816, .0000},
  {660, .1649, .0610, .0000},
  {665, .1212, .0446, .0000},
  {670, .0874, .0320, .0000},
  {675, .0636, .0232, .0000},
  /*************************/
  {680, .0468, .0170, .0000},
  {685, .0329, .0119, .0000},
  {690, .0227, .0082, .0000},
  {695, .0158, .0057, .0000},
  {700, .0114, .0041, .0000},
  /*************************/
  {705, .0081, .0029, .0000},
  {710, .0058, .0021, .0000},
  {715, .0041, .0015, .0000},
  {720, .0029, .0010, .0000},
  {725, .0020, .0007, .0000},
  /*************************/
  {730, .0014, .0005, .0000},
  {735, .0010, .0004, .0000},
  {740, .0007, .0003, .0000},
  {745, .0005, .0002, .0000},
  {750, .0003, .0001, .0000},
  /*************************/
  {755, .0002, .0001, .0000},
  {760, .0002, .0001, .0000},
  {765, .0001, .0000, .0000},
  {770, .0001, .0000, .0000},
  {775, .0000, .0000, .0000}
};

Spectrum PhBSpectrum::wavelength2xyz(float wavelength, float luminance)
{
  int pos = int((wavelength - 380) * .2);
  float *f = &(wavelength_table[pos+0][0]);
  float *s = &(wavelength_table[pos+1][0]);

  float w1 = ((float)(wavelength - 380) * .2) - pos;

  float x = (s[1] - f[1]) * w1  +  f[1];
  float y = (s[2] - f[2]) * w1  +  f[2];
  float z = (s[3] - f[3]) * w1  +  f[3];

  // convert to XYZ representation.
  return Spectrum(x * luminance,
		  y * luminance,
		  z * luminance);
}


}  // namespace xrml
