/* PhBTabulatedSpectrum.C: PhBTabulatedSpectrum nodes (public source) */

#include "PhBTabulatedSpectrum.H"

namespace xrml {

void PhBTabulatedSpectrum::render(void)
{
  int numSamples = (wavelengths.size > values.size) ? values.size : wavelengths.size;
  Spectrum sum = Spectrum(0.);

  for(int w=0; w < numSamples; w++)
   {
      sum += wavelength2xyz(wavelengths[w], values[w]);
    }

  value = sum * scale / numSamples;
}

}  // namespace xrml
