/* PhBTexture.C: PhBTexture nodes (public source) */

#include "PhBTexture.H"
#include <stdio.h>

namespace xrml {

void PhBTexture::render(void)
{
  Warning(NULL, "PhBTexture::render(): not yet implemented");
}

long PhBTexture::nrChannels(void)
{
  Warning(NULL, "PhBTexture::nrChannels(): not yet implemented");
  return(0);
}

long PhBTexture::width(void)
{
  Warning(NULL, "PhBTexture::width(): not yet implemented");
  return(0);
}

long PhBTexture::height(void)
{
  Warning(NULL, "PhBTexture::height(): not yet implemented");
  return(0);
}

float *PhBTexture::values(double u, double v, int *nrChannels)
{
  Warning(NULL, "PhBTexture::values(): not yet implemented");
  if (nrChannels) *nrChannels = 0;
  return NULL;
}

void PhBTexture::Dvalues(double u, double v, float *dX, float *dY, float *dZ)
{
  Warning(NULL, "PhBTexture::Dvalues(): not yet implemented");
}

void PhBTexture::DumpTexture(char *filename, long resx, long resy)
{
  cerr << "Dumping Texture in file:" << filename << " at a resolution of " << resx << "x" << resy << "\n";

  float *c;
  FILE *f = fopen(filename, "w");

  if (f == NULL) Error(NULL, "Unable to open file to DumpTexture");

  fprintf(f, "P6\n%ld %ld\n255\n", resx, resy);

  for(double y = 0; y < resy; y++)

    for(double x = 0; x < resx; x++)
      {
	c = values(x/resx, y/resy, NULL);

	  for(int chan = 0; chan < 3; chan++)
	    fputc((int)(c[chan] * 255), f);
      }
  fclose(f);
}

void PhBTexture::Dump(long resx, long resy, long w, long h)
{
  float *c;
  cerr << "Dumping texture area (0,0)-(" << w << "," << h << ")" << " at a resolution of " << resx << "x" << resy << "\n";
  for(double y=0; y < h; y++)
    for(double x=0; x < w; x++)
      {
	c = values(x/resx, y/resy, NULL);
	for(int chan = 0; chan < 3; chan++)
	  cerr << c[chan] << "|";
      }
}


}  // namespace xrml
