// PhBTextureEmitter.H: PhBTextureEmitter nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _PhBTextureEmitter_H_
#define _PhBTextureEmitter_H_

#include "xrml.H"
#include "PhBEmitter.H"
#include "PhBTexture.H"

// utility includes
// end of utility includes

namespace xrml {
#define PhBTextureEmitterTypeId 	"PhBTextureEmitter"
extern bool IsPhBTextureEmitter(SFNode*);

class PhBTextureEmitter: public virtual SFNode, public PhBEmitter {
private:
  //
  void clone_here(const PhBTextureEmitter&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    texture_updated = 0x1,
    channel_updated = 0x2 
  };
  
protected:
  // raw children nodes (can be PROTO) + synchronize methods:
  SFNode* 	_texture;
  void 	synchronize_texture(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  PhBTextureEmitter();
  PhBTextureEmitter(const PhBTextureEmitter&);
  PhBTextureEmitter& operator=(const PhBTextureEmitter&);
  virtual ~PhBTextureEmitter();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  PhBTexture*      	texture;
  SFInt32          	channel;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_texture(SFNode*);
  void             	set_channel(const SFInt32&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_texture(SFNode*);
  bool             	assign_channel(const SFInt32&);
  
  // update status
  inline bool      	texture_is_updated(void) { return (status & texture_updated); }
  inline void      	texture_clear_update(void) { status &= ~texture_updated; }
  inline bool      	channel_is_updated(void) { return (status & channel_updated); }
  inline void      	channel_clear_update(void) { status &= ~channel_updated; }
  
  // utility members
  float mapEmittance;
  float *rowEmittance;
  float mapSum;

  float emittance(int range);
  Vec3 sample(float xi1, float xi2, int range);
  float eval(const Vec3& direction, int range, float *pdf);
  
protected:
  void precalc(void);

  inline void util_init(void) { rowEmittance = NULL; }
  inline void util_clone(const PhBTextureEmitter& src) { }
  inline void util_destruct(void) { if(!rowEmittance) delete[] rowEmittance; }
};

// end of utility members
} // namespace xrml
#endif /*_PhBTextureEmitter_H_*/
