// PhBTexturedBackground.H: PhBTexturedBackground nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _PhBTexturedBackground_H_
#define _PhBTexturedBackground_H_

#include "xrml.H"
#include "PhBBackground.H"
#include "Children.H"
#include "PhBTexture.H"
#include "PhBSpectrum.H"
#include "TextureTransform.H"
#include "PhBBackgroundProjection.H"

// utility includes
// end of utility includes

namespace xrml {
#define PhBTexturedBackgroundTypeId 	"PhBTexturedBackground"
extern bool IsPhBTexturedBackground(SFNode*);

class PhBTexturedBackground: public virtual SFNode, public PhBBackground, public Children {
private:
  //
  void clone_here(const PhBTexturedBackground&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    isBound_updated = 0x1,
    texture_updated = 0x2,
    spectralBasis_updated = 0x4,
    spectralWeights_updated = 0x8,
    viewOrientation_updated = 0x10,
    textureTransform_updated = 0x20,
    textureProjection_updated = 0x40 
  };
  
protected:
  // raw children nodes (can be PROTO) + synchronize methods:
  SFNode* 	_texture;
  void 	synchronize_texture(void);
  MFNode 	_spectralBasis;
  void 	synchronize_spectralBasis(void);
  SFNode* 	_textureTransform;
  void 	synchronize_textureTransform(void);
  SFNode* 	_textureProjection;
  void 	synchronize_textureProjection(void);

  // raw eventOut posting:
  void post_isBound(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  PhBTexturedBackground();
  PhBTexturedBackground(const PhBTexturedBackground&);
  PhBTexturedBackground& operator=(const PhBTexturedBackground&);
  virtual ~PhBTexturedBackground();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  PhBTexture*      	texture;
  array<PhBSpectrum*> 	spectralBasis;
  MFFloat          	spectralWeights;
  SFRotation       	viewOrientation;
  TextureTransform* 	textureTransform;
  PhBBackgroundProjection* 	textureProjection;
  
  // eventIns:
  void             	set_bind(const SFBool&);
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_texture(SFNode*);
  void             	set_spectralBasis(const MFNode&);
  void             	set_spectralWeights(const MFFloat&);
  void             	set_viewOrientation(const SFRotation&);
  void             	set_textureTransform(SFNode*);
  void             	set_textureProjection(SFNode*);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_texture(SFNode*);
  bool             	assign_spectralBasis(const MFNode&);
  bool             	assign_spectralWeights(const MFFloat&);
  bool             	assign_viewOrientation(const SFRotation&);
  bool             	assign_textureTransform(SFNode*);
  bool             	assign_textureProjection(SFNode*);
  
  // eventOuts:
  //  SFBool            	isBound;
  void             	post_isBound(const SFBool& val);
  
  // update status
  inline bool      	isBound_is_updated(void) { return (status & isBound_updated); }
  inline void      	isBound_clear_update(void) { status &= ~isBound_updated; }
  inline bool      	texture_is_updated(void) { return (status & texture_updated); }
  inline void      	texture_clear_update(void) { status &= ~texture_updated; }
  inline bool      	spectralBasis_is_updated(void) { return (status & spectralBasis_updated); }
  inline void      	spectralBasis_clear_update(void) { status &= ~spectralBasis_updated; }
  inline bool      	spectralWeights_is_updated(void) { return (status & spectralWeights_updated); }
  inline void      	spectralWeights_clear_update(void) { status &= ~spectralWeights_updated; }
  inline bool      	viewOrientation_is_updated(void) { return (status & viewOrientation_updated); }
  inline void      	viewOrientation_clear_update(void) { status &= ~viewOrientation_updated; }
  inline bool      	textureTransform_is_updated(void) { return (status & textureTransform_updated); }
  inline void      	textureTransform_clear_update(void) { status &= ~textureTransform_updated; }
  inline bool      	textureProjection_is_updated(void) { return (status & textureProjection_updated); }
  inline void      	textureProjection_clear_update(void) { status &= ~textureProjection_updated; }
  
  // utility members
  Spectrum totalPower;
  float mapLuminance;
  float *rowPower;

  Spectrum eval(const Vec3& position, const Vec3& direction, const Spectrum& specWeight, float *pdf);
  Vec3 sample(const Spectrum& specWeight, const Vec3& position, const float xi1, const float xi2, Spectrum *value, float *pdf);
  Spectrum power(const Vec3& position);
  
protected:
  void precalc(void);

  inline void util_init(void) { rowPower = NULL; }
  inline void util_clone(const PhBTexturedBackground& src) { }
  inline void util_destruct(void) { if(!rowPower) delete[] rowPower; }
};

// end of utility members
} // namespace xrml
#endif /*_PhBTexturedBackground_H_*/
