// PhBTexturedMedium.H: PhBTexturedMedium nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _PhBTexturedMedium_H_
#define _PhBTexturedMedium_H_

#include "xrml.H"
#include "PhBMedium.H"
#include "PhB3DTexture.H"
#include "PhB3DTextureTransform.H"

// utility includes
// end of utility includes

namespace xrml {
#define PhBTexturedMediumTypeId 	"PhBTexturedMedium"
extern bool IsPhBTexturedMedium(SFNode*);

class PhBTexturedMedium: public virtual SFNode, public PhBMedium {
private:
  //
  void clone_here(const PhBTexturedMedium&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    texture_updated = 0x1,
    media_updated = 0x2,
    textureTransform3D_updated = 0x4 
  };
  
protected:
  // raw children nodes (can be PROTO) + synchronize methods:
  SFNode* 	_texture;
  void 	synchronize_texture(void);
  MFNode 	_media;
  void 	synchronize_media(void);
  SFNode* 	_textureTransform3D;
  void 	synchronize_textureTransform3D(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  PhBTexturedMedium();
  PhBTexturedMedium(const PhBTexturedMedium&);
  PhBTexturedMedium& operator=(const PhBTexturedMedium&);
  virtual ~PhBTexturedMedium();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  PhB3DTexture*    	texture;
  array<PhBMedium*> 	media;
  PhB3DTextureTransform* 	textureTransform3D;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_texture(SFNode*);
  void             	set_media(const MFNode&);
  void             	set_textureTransform3D(SFNode*);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_texture(SFNode*);
  bool             	assign_media(const MFNode&);
  bool             	assign_textureTransform3D(SFNode*);
  
  // update status
  inline bool      	texture_is_updated(void) { return (status & texture_updated); }
  inline void      	texture_clear_update(void) { status &= ~texture_updated; }
  inline bool      	media_is_updated(void) { return (status & media_updated); }
  inline void      	media_clear_update(void) { status &= ~media_updated; }
  inline bool      	textureTransform3D_is_updated(void) { return (status & textureTransform3D_updated); }
  inline void      	textureTransform3D_clear_update(void) { status &= ~textureTransform3D_updated; }
  
  // utility members
  
protected:
  inline void util_init(void) { }
  inline void util_clone(const PhBTexturedMedium& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_PhBTexturedMedium_H_*/
